//
//  FILE NAME: CIDKernel_MathLib.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module provides the wrapper functions that turn around and call the
//  RTL math operations.
//
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"


// ----------------------------------------------------------------------------
//  Include some system headers
// ----------------------------------------------------------------------------
#include    <math.h>



// ----------------------------------------------------------------------------
//  Log functions
// ----------------------------------------------------------------------------

tCIDLib::TFloat8 TMathLib::f8Log10(const tCIDLib::TFloat8 f8Value)
{
    return log10(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8Log(const tCIDLib::TFloat8 f8Value)
{
    return log(f8Value);
}


// ----------------------------------------------------------------------------
//  Geometrical functions
// ----------------------------------------------------------------------------

tCIDLib::TFloat8
TMathLib::f8Hypotenuse(const tCIDLib::TFloat8 f8X, const tCIDLib::TFloat8 f8Y)
{
    return hypot(f8X, f8Y);
}



// ----------------------------------------------------------------------------
//  Miscellaneous functions
// ----------------------------------------------------------------------------

tCIDLib::TFloat8 TMathLib::f8Abs(const tCIDLib::TFloat8 f8Value)
{
    return fabs(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8Exponent(const tCIDLib::TFloat8 f8Value)
{
    return exp(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8Floor(const tCIDLib::TFloat8 f8Value)
{
    return floor(f8Value);
}

tCIDLib::TFloat8
TMathLib::f8Mod(const tCIDLib::TFloat8 f8Value, const tCIDLib::TFloat8 f8Divisor)
{
    return fmod(f8Value, f8Divisor);
}

tCIDLib::TFloat8
TMathLib::f8Power(const tCIDLib::TFloat8 f8Value, const tCIDLib::TFloat8 f8Power)
{
    return pow(f8Value, f8Power);
}

tCIDLib::TFloat8
TMathLib::f8Split(const tCIDLib::TFloat8 f8Value, tCIDLib::TFloat8& f8Integral)
{
    return modf(f8Value, &f8Integral);
}



// ----------------------------------------------------------------------------
//  Transcendental functions
// ----------------------------------------------------------------------------

tCIDLib::TFloat8 TMathLib::f8ArcCosine(const tCIDLib::TFloat8 f8Value)
{
    return acos(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8ArcSine(const tCIDLib::TFloat8 f8Value)
{
    return asin(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8Cosine(const tCIDLib::TFloat8 f8Value)
{
    return cos(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8HyperCosine(const tCIDLib::TFloat8 f8Value)
{
    return cosh(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8HyperSine(const tCIDLib::TFloat8 f8Value)
{
    return sinh(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8HyperTangent(const tCIDLib::TFloat8 f8Value)
{
    return tanh(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8Sine(const tCIDLib::TFloat8 f8Value)
{
    return sin(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8Square(const tCIDLib::TFloat8 f8Value)
{
    return f8Value * f8Value;
}

tCIDLib::TFloat8 TMathLib::f8SqrRoot(const tCIDLib::TFloat8 f8Value)
{
    return sqrt(f8Value);
}

tCIDLib::TFloat8 TMathLib::f8Tangent(const tCIDLib::TFloat8 f8Value)
{
    return tan(f8Value);
}


// ----------------------------------------------------------------------------
//  Random number functions
// ---------------------------------------------------------------------------
tCIDLib::TCard4 TMathLib::c4RandomNum()
{
    return rand();
}

tCIDLib::TVoid TMathLib::SeedRandom(const tCIDLib::TCard4 c4Seed)
{
    srand(c4Seed);
}
