//
//  FILE NAME: CIDKernel_LowLevelPopUp.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/26/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_LowLevelPopUp.Cpp module. This
//  module implements the TKrnlPopUp class, which is a very safe and simple
//  way to report errors that might occur at very low levels in the system
//  (and therefore potentially have little working infrastructure to call
//  upon.)
//
//  CAVEATS/GOTCHAS:
//
//  1)  Because the stupid compiler generates non-UNICode strings for
//      the __FILE__ macro, this guy accepts for now short character
//      strings as well as UNICode strings for the module name.
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlPopup
//  PREFIX: kpu
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlPopup
{
    public  :
        // -------------------------------------------------------------------
        //  Constructors and destructors
        // -------------------------------------------------------------------
        TKrnlPopup();

        ~TKrnlPopup();


        // -------------------------------------------------------------------
        //  Public, static methods
        // -------------------------------------------------------------------
        static tCIDLib::TVoid Show
        (
            const   tCIDLib::Tch* const     pszModule
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::Tch* const     pszTitle1
            , const tCIDLib::Tch* const     pszTitle2
            , const tCIDLib::TErrCode       errcId
            , const tCIDLib::TErrCode       errcKrnlId
            , const tCIDLib::TOSErrCode     errcHostId
            , const tCIDLib::Tch* const     pszMsg
            , const tCIDLib::Tch* const     pszMsg2 = 0
        );

        static tCIDLib::TVoid Show
        (
            const   tCIDLib::Tsch* const    pszModule
            , const tCIDLib::TCard4         c4LineNum
            , const tCIDLib::Tch* const     pszTitle1
            , const tCIDLib::Tch* const     pszTitle2
            , const tCIDLib::TErrCode       errcId
            , const tCIDLib::TErrCode       errcKrnlId
            , const tCIDLib::TOSErrCode     errcHostId
            , const tCIDLib::Tch* const     pszMsg
            , const tCIDLib::Tch* const     pszMsg2 = 0
        );


    private :
        // -------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // -------------------------------------------------------------------
        TKrnlPopup(const TKrnlPopup&);

        tCIDLib::TVoid operator=(const TKrnlPopup&);
};

#pragma pack(pop)
