//
//  FILE NAME: CIDKernel_LowLevelPopUp.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/25/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module implements the the TKrnlPopup class, which is a safe and
//  simple means of popping up an emergency message.
//
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"


// ----------------------------------------------------------------------------
//  Local types
//
//  __TDlgInfo
//      This is a quickie local structure that is used to get the dialog
//      information to the dialog proc. The first is for incoming info.
// ----------------------------------------------------------------------------
struct  __TDlgInfo
{
    const   tCIDLib::Tch*           pszModule;
            tCIDLib::TCard4         c4LineNum;
    const   tCIDLib::Tch*           pszTitle1;
    const   tCIDLib::Tch*           pszTitle2;
            tCIDLib::TErrCode       errcId;
            tCIDLib::TErrCode       errcKrnlId;
            tCIDLib::TOSErrCode     errcHostId;
    const   tCIDLib::Tch*           pszMsg;
    const   tCIDLib::Tch*           pszMsg2;
};


// ----------------------------------------------------------------------------
//  Local functions
// ----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: __mresDlgProc
//
// DESCRIPTION:
//
//  This is the dialog procedure for the popup dialog. It basically just
//  gets the data into the dialog, then waits for an Ok. The dialog data
//  is a pointer to a __TDlgInfo structure.
// ---------------------------------------
//   INPUT: hwndDlg is the handle to this dialog
//          iMsg is the message we are getting
//          wParm, lParm are the two message parameters
//
//  OUTPUT: None
//
//  RETURN: Depends on the message.
//
tCIDLib::TMsgResult WNDPROCAPI
__mresDlgProc(  HWND                hwndDlg
                , tCIDLib::TUInt    uMsg
                , tCIDLib::TUInt    uParam
                , tCIDLib::TInt4    i4Param)
{
    if (uMsg == WM_INITDIALOG)
    {
        const  tCIDLib::TCard4  c4MsgSz = 511;
        static tCIDLib::Tch     szTmp[c4MsgSz+1];
        const  tCIDLib::Tch*    pszTmp;

        // Get the passed in information
        const __TDlgInfo* const pInfo = (const __TDlgInfo*)i4Param;

        // Store the pointer for later reference
        SetWindowLong(hwndDlg, DWL_USER, tCIDLib::TInt4(pInfo));

        //
        //  Now init all of the simple fields, which are just straight
        //  sets of the window text.
        //
        SetDlgItemText(hwndDlg, IDC_POPUP_TITLE1, kCIDKernel_::pszTitle1);
        SetDlgItemText(hwndDlg, IDC_POPUP_TITLE2, kCIDKernel_::pszTitle2);
        SetDlgItemInt(hwndDlg, IDC_POPUP_CIDERR, pInfo->errcId, 0);
        SetDlgItemInt(hwndDlg, IDC_POPUP_KRNLERR, pInfo->errcKrnlId, 0);
        SetDlgItemInt(hwndDlg, IDC_POPUP_HOSTERR, pInfo->errcHostId, 0);

        // Get the process name from a system info object
        SetDlgItemText
        (
            hwndDlg
            , IDC_POPUP_APPNAME
            , TKrnlSysInfo::pszProcessName()
        );

        //
        //  Build the module and line information and put it into its
        //  control. Its just module and line number with a period
        //  between them. We toss the path part of the module name, which
        //  most compilers will put on it.
        //
        pszTmp = TRawStr::pszFindLastChar(pInfo->pszModule, L'\\');
        if (!pszTmp)
            TRawStr::CopyStr(szTmp, pInfo->pszModule, c4MsgSz);
        else
            TRawStr::CopyStr(szTmp, pszTmp+1, c4MsgSz);
        TRawStr::CatStr(szTmp, L".", c4MsgSz);
        TRawStr::FormatVal
        (
            pInfo->c4LineNum
            , &szTmp[TRawStr::c4StrLen(szTmp)]
            , c4MsgSz
        );
        SetDlgItemText(hwndDlg, IDC_POPUP_MODLINE, szTmp);

        //
        //  Build up the error text from the available info and put it
        //  into the control.
        //
        TRawStr::CopyStr(szTmp, pInfo->pszMsg, c4MsgSz);
        if (TRawStr::c4StrLen(pInfo->pszMsg2))
        {
            TRawStr::CatStr(szTmp, L"\r\n\r\n", c4MsgSz);
            TRawStr::CatStr(szTmp, pInfo->pszMsg2, c4MsgSz);
        }
        SetDlgItemText(hwndDlg, IDC_POPUP_TEXT, szTmp);

        //
        //  Put the focus on the Ok button, because none of the controls
        //  accept any input.
        //
        SetFocus(GetDlgItem(hwndDlg, IDC_POPUP_OK));
        return 0;
    }
     else if (uMsg == WM_COMMAND)
    {
        if ((TRawBits::c2High16From32(uParam) == BN_CLICKED)
        &&  (TRawBits::c2Low16From32(uParam) == IDC_POPUP_OK))
        {
            EndDialog(hwndDlg, 0);
            return 1;
        }
    }
    return 0;
}


// ----------------------------------------------------------------------------
//   CLASS: TKrnlPopup
//  PREFIX: kpu
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TKrnlPopup: Constructors and destructors
// ----------------------------------------------------------------------------

TKrnlPopup::TKrnlPopup()
{
}

TKrnlPopup::~TKrnlPopup()
{
}


// ----------------------------------------------------------------------------
//  TKrnlPopup: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TKrnlPopup::Show(const   tCIDLib::Tch* const pszModule
                                , const tCIDLib::TCard4     c4LineNum
                                , const tCIDLib::Tch* const pszTitle1
                                , const tCIDLib::Tch* const pszTitle2
                                , const tCIDLib::TErrCode   errcId
                                , const tCIDLib::TErrCode   errcKrnlId
                                , const tCIDLib::TOSErrCode errcHostId
                                , const tCIDLib::Tch* const pszMsg
                                , const tCIDLib::Tch* const pszMsg2)
{
    //
    //  Load the dialog box, filling in a dialog data structure first
    //  with the information.
    //
    __TDlgInfo  DlgInfo;
    DlgInfo.pszModule   = pszModule;
    DlgInfo.c4LineNum   = c4LineNum;
    DlgInfo.pszTitle1   = pszTitle1;
    DlgInfo.pszTitle2   = pszTitle2;
    DlgInfo.errcId      = errcId;
    DlgInfo.errcKrnlId  = errcKrnlId;
    DlgInfo.errcHostId  = errcHostId;
    DlgInfo.pszMsg      = pszMsg;
    DlgInfo.pszMsg2     = pszMsg2;
    tCIDLib::TInt4 i4Res = DialogBoxParam
    (
        _hmodKernel
        , MAKEINTRESOURCE(IDD_POPUP)
        , GetDesktopWindow()
        , &__mresDlgProc
        , tCIDLib::TInt4(&DlgInfo)
    );
}

tCIDLib::TVoid TKrnlPopup::Show(const   tCIDLib::Tsch* const pszModule
                                , const tCIDLib::TCard4     c4LineNum
                                , const tCIDLib::Tch* const pszTitle1
                                , const tCIDLib::Tch* const pszTitle2
                                , const tCIDLib::TErrCode   errcId
                                , const tCIDLib::TErrCode   errcKrnlId
                                , const tCIDLib::TOSErrCode errcHostId
                                , const tCIDLib::Tch* const pszMsg
                                , const tCIDLib::Tch* const pszMsg2)
{
    // Convert the string to a UNICode string
    tCIDLib::Tch*   pszXlated = TRawStr::pszConvert(pszModule);
    THeapJanitor    janXlat(pszXlated);

    // And now call the real version
    Show
    (
        pszXlated
        , c4LineNum
        , pszTitle1
        , pszTitle2
        , errcId
        , errcKrnlId
        , errcHostId
        , pszMsg
        , pszMsg2
    );
}
