//
// NAME: CIDKernel_LockJanitors.Hpp
// 
// DESCRIPTION: 
// 
//  This is an internal header that defines a couple of small janitor classesfor
//  internal locking of kernel mutex, raw mutexes, kernel critical sections.
//
// AUTHOR: Dean Roddey
// 
// CREATE DATE: 01/11/94
// 
// COPYRIGHT: 1992..1997, 'CIDCorp
// 


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlRawMutexLocker
//  PREFIX: kmtxl
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlRawMutexLocker
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlRawMutexLocker
        (
            const   tCIDLib::TMtxHandle     hmtxToLock
            , const tCIDLib::TCard4         c4MilliSecs = kCIDLib::c4MaxWait
        );

        ~TKrnlRawMutexLocker();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Release();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKnrlRawMutexLocker(const TKrnlRawMutexLocker&);

        tCIDLib::TVoid operator=(const TKrnlRawMutexLocker&);


        // --------------------------------------------------------------------
        //  Private data
        //
        //  __hmtxLocked
        //      This is the stored handle of the raw mutex that we are
        //      locking.
        // --------------------------------------------------------------------
        tCIDLib::TMtxHandle     __hmtxLocked;
};


// ----------------------------------------------------------------------------
//   CLASS: TKrnlMutexLocker
//  PREFIX: kmtxl
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlMutexLocker
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlMutexLocker
        (
                    TKrnlMutex* const       pkmtxToLock
            , const tCIDLib::TCard4         c4MilliSecs = kCIDLib::c4MaxWait
        );

        ~TKrnlMutexLocker();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Release();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKnrlMutexLocker(const TKrnlMutexLocker&);

        tCIDLib::TVoid operator=(const TKrnlMutexLocker&);


        // --------------------------------------------------------------------
        //  Private data
        //
        //  __pmtxLocked
        //      This is the stored pointer the mutex object that we are
        //      locking.
        // --------------------------------------------------------------------
        TKrnlMutex*             __pkmtxLocked;
};


// ----------------------------------------------------------------------------
//   CLASS: TKrnlCritSecLocker
//  PREFIX: kcrsl
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlCritSecLocker
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlCritSecLocker
        (
                    TKrnlCritSec* const     pkcrsToLock
        );

        ~TKrnlCritSecLocker();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Release();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKnrlMutexLocker(const TKrnlCritSecLocker&);

        tCIDLib::TVoid operator=(const TKrnlCritSecLocker&);


        // --------------------------------------------------------------------
        //  Private data
        //
        //  __pkcrsLocked
        //      This is the stored pointer the critical section object that
        //      we are locking.
        // --------------------------------------------------------------------
        TKrnlCritSec*   __pkcrsLocked;
};

#pragma pack(pop)
