//
//  FILE NAME: CIDKernel_LockJanitors.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/11/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module implements some simple locker classes for kernel mutexes and
//  critical sections. These are primarily for internal use and for CIDLib.Dll
//  because they have to use these kernel classes directly.
//
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"


// ----------------------------------------------------------------------------
//   CLASS: TKrnlRawMutexLocker
//  PREFIX: kmtxl
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TKrnlRawMutexLocker: Constructors and operators
// ----------------------------------------------------------------------------

TKrnlRawMutexLocker::TKrnlRawMutexLocker
                        (const  tCIDLib::TMtxHandle     hmtxToLock
                        , const tCIDLib::TCard4         c4MilliSecs) :

    __hmtxLocked(hmtxToLock)
{
    tCIDLib::TCard4 c4Reason = WaitForSingleObject
    (
        __hmtxLocked
        , c4MilliSecs
    );

    if ((c4Reason == WAIT_FAILED)
    ||  (c4Reason == WAIT_TIMEOUT)
    ||  (c4Reason == WAIT_ABANDONED))
    {
        TKrnlError::ThrowKrnlError();
    }
}

TKrnlRawMutexLocker::~TKrnlRawMutexLocker()
{
    Release();
}

// ----------------------------------------------------------------------------
//  TKrnlRawMutexLocker: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TKrnlRawMutexLocker::Release()
{
    // If already released or never set, then do nothing
    if (!__hmtxLocked)
        return;

    if (!::ReleaseMutex(__hmtxLocked))
        TKrnlError::ThrowKrnlError();

    // Zero the handle to let it go
    __hmtxLocked = 0;
}



// ----------------------------------------------------------------------------
//   CLASS: TKrnlMutexLocker
//  PREFIX: kmtxl
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TKrnlMutexLocker: Constructors and operators
// ----------------------------------------------------------------------------

TKrnlMutexLocker::TKrnlMutexLocker(         TKrnlMutex* const   pkmtxToLock
                                    , const tCIDLib::TCard4     c4MilliSecs) :
    __pkmtxLocked(pkmtxToLock)
{
    __pkmtxLocked->Lock(c4MilliSecs);
}

TKrnlMutexLocker::~TKrnlMutexLocker()
{
    Release();
}


// ----------------------------------------------------------------------------
//  TKrnlMutexLocker: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TKrnlMutexLocker::Release()
{
    // If its been released or never was set, don't bother
    if (!__pkmtxLocked)
        return;

    __pkmtxLocked->Unlock();
    __pkmtxLocked = 0;
}




// ----------------------------------------------------------------------------
//   CLASS: TKrnlCritSecLocker
//  PREFIX: kmtxl
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TKrnlCritSecLocker: Constructors and operators
// ----------------------------------------------------------------------------

TKrnlCritSecLocker::TKrnlCritSecLocker(TKrnlCritSec* const pkcrsToLock) :

    __pkcrsLocked(pkcrsToLock)
{
    __pkcrsLocked->Enter();
}

TKrnlCritSecLocker::~TKrnlCritSecLocker()
{
    Release();
}


// ----------------------------------------------------------------------------
//  TKrnlCritSecLocker: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TKrnlCritSecLocker::Release()
{
    // If its been released or never was set, don't bother
    if (!__pkcrsLocked)
        return;

    __pkcrsLocked->Exit();
    __pkcrsLocked = 0;
}
