//
//  FILE NAME: CIDKernel_Locale.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_Locale.Cpp module. This file
//  implements the TKrnlLocale namespace. This namespace provides a couple
//  of APIs to query locale information.
//
//  CAVEATS/GOTCHAS:
//
//  1)  This stuff is not thread safe because it assumes that it is being
//      used by TLocale (in CIDLib.Dll) which provides that synchronization.
//


#pragma pack(push, CIDLIBPACK)

// ---------------------------------------------------------------------------
//   CLASS: TKrnlLocale
//  PREFIX: kloc
// ---------------------------------------------------------------------------
namespace TKrnlLocale
{
    // -------------------------------------------------------------------
    //  Nested types. This is a structure used to return the information
    //  for a requested locale.
    //
    //  Non-monetary values
    //  -------------------
    //  c4GroupSize
    //      Indicates the grouping of characters into thousands or
    //      whatever, for numeric and monetary values.
    //
    //  chDecimalSym
    //      The character for use in floating point numeric values.
    //      0 if none.
    //
    //  chThousandsSep
    //      The separator value for thousands in numeric values.
    //      0 if none.
    //
    //  chPosSign
    //  chNegSign
    //      The +/- signs for numeric values.
    //
    //
    //  Monetary values
    //  ---------------
    //
    //  bNegSpacedSym
    //  bNegSymPreceds
    //      These indicate whether the currency symbol precedes the sign
    //      for negative values or comes afterwards, and whether the sign
    //      separated by a space from the value.
    //
    //  bPosSpacedSym
    //  bPosSymPreceds
    //      These indicate whether the currency symbol precedes the sign
    //      for positive values or comes afterwards, and whether the sign
    //      separated by a space from the value.
    //
    //  c4MonetaryDecDigits
    //      The number of decimal digits to the right of the decimal
    //      in monetary values.
    //
    //  c4MonetaryGrpSize
    //      The size of digit groups in monetary values
    //
    //  chCurrencySymbol
    //      The symbol that represents a monetary value. 0 if none.
    //
    //  chMonetaryDecimalSym
    //      The symbol used as the decimal place in monetary values.
    //
    //  chMonetaryGrpSep
    //
    //  eNegSignPosition
    //  ePosSignPosition
    //      These control whether the sign goes before or after the value
    //      in positive and negative numbers.
    //
    //  
    //  szLocale
    //      The name of the currently set locale.
    // -------------------------------------------------------------------
    struct TLocaleInfo
    {
        // These are for non-monetary values
        tCIDLib::TCard4         c4GroupSize;
        tCIDLib::Tch            chDecimalSym;
        tCIDLib::Tch            chThousandsSep;
        tCIDLib::Tch            chPosSign;
        tCIDLib::Tch            chNegSign;

        // These are for monetary values
        tCIDLib::TBoolean       bNegSpacedSym;
        tCIDLib::TBoolean       bNegSymPrecedes;
        tCIDLib::TBoolean       bPosSpacedSym;
        tCIDLib::TBoolean       bPosSymPrecedes;
        tCIDLib::TCard4         c4MonetaryDecDigits;
        tCIDLib::TCard4         c4MonetaryGrpSize;
        tCIDLib::Tch            chCurrencySymbol;
        tCIDLib::Tch            chMonetaryDecimalSym;
        tCIDLib::Tch            chMonetaryGrpSep;
        tCIDLib::ESignPositions eNegSignPosition;
        tCIDLib::ESignPositions ePosSignPosition;

        tCIDLib::TZStr128       szLocale;
    };


    // -------------------------------------------------------------------
    //  Public methods
    // -------------------------------------------------------------------
    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid QueryLocaleInfo
    (
                TLocaleInfo&            lociToFill
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetLocale
    (
        const   tCIDLib::Tch* const     pszLocaleName
    );
};

#pragma pack(pop)
