//
//  FILE NAME: CIDKernel_HeapJanitor.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header implements a very simple, all inline janitor for dealing
//  with heap allocated buffers. This class is used publically in higher level
//  code.
//
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: THeapJanitor
//  PREFIX: jan
// -----------------------------------------------------------------------------
class  THeapJanitor
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        THeapJanitor
        (
                    tCIDLib::TVoid* const   pToDelete
        );

        ~THeapJanitor();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid Orphan();


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        THeapJanitor();

        THeapJanitor(const THeapJanitor&);

        tCIDLib::TVoid operator=(const THeapJanitor&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __pToSanitize
        //      This is the pointer to the buffer that must be destroyed
        //      when this object is destroyed.
        // ---------------------------------------------------------------------
        tCIDLib::TVoid*         __pToSanitize;
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline THeapJanitor::THeapJanitor(tCIDLib::TVoid* const pToDelete) :

    __pToSanitize(pToDelete)
{
}

inline THeapJanitor::~THeapJanitor()
{
    delete __pToSanitize;
}


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TVoid THeapJanitor::Orphan()
{
    __pToSanitize = 0;
}
