//
//  FILE NAME: CIDKernel_HashMap.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 08/13/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_HashMap.Cpp module. This module
//  implements a very simple hash map for use within the kernel. Its used
//  in a couple of places like storage of the environment values and such.
//
//  Its very simplistic and assumes that its key and data are both
//  raw strings.
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlHashMap
//  PREFIX: khshm
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlHashMap
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlHashMap
        (
            const   tCIDLib::TCard4         c4Modulus
        );

        ~TKrnlHashMap();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Add
        (
            const   tCIDLib::Tch* const     pszKey
            , const tCIDLib::Tch* const     pszValue
        );

        tCIDLib::TBoolean bNext();

        tCIDLib::TBoolean bResetIter();

        tCIDLib::TCard4 c4ElemCount() const;

        tCIDLib::TVoid Flush();

        const tCIDLib::Tch* pszCurKey() const;

        const tCIDLib::Tch* pszCurValue() const;

        const tCIDLib::Tch* pszValueForKey
        (
            const   tCIDLib::Tch* const     pszKey
        );

        tCIDLib::TVoid RemoveKey
        (
            const   tCIDLib::Tch* const     pszKey
        );

        tCIDLib::TVoid UpdateKey
        (
            const   tCIDLib::Tch* const     pszKey
            , const tCIDLib::Tch* const     pszNewValue
        );


    private :
        // --------------------------------------------------------------------
        //  Private, nested types
        // --------------------------------------------------------------------
        struct TNode
        {
            tCIDLib::Tch*   pszKey;
            tCIDLib::Tch*   pszValue;

            TNode*          pnodeNext;
        };


        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlHashMap();

        TKrnlHashMap(const TKrnlHashMap&);

        tCIDLib::TVoid operator=(const TKrnlHashMap&);


        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        TKrnlHashMap::TNode* TKrnlHashMap::__pnodeFind
        (
            const  tCIDLib::Tch* const      pszKeyToFind
            ,       tCIDLib::THashVal&      hshElem
        )   const;


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __apnodeTable
        //      This is list of node headers, each one of which contains
        //      the nodes which hashed to that value.
        //
        //  __c4CurList
        //      This is the current list that the iterator is pointing to.
        //
        //  __c4ElemCount
        //      The number of elements in the map.
        //
        //  __c4Modulus
        //      THis is the modulus divisor for the hashing of keys. There
        //      are this many entries in the __apnodeTable array.
        //
        //  __pnodeCur
        //      This is the current node with the current list that the
        //      iterator is pointing to.
        // --------------------------------------------------------------------
        TNode**             __apnodeTable;
        tCIDLib::TCard4     __c4CurList;
        tCIDLib::TCard4     __c4ElemCount;
        tCIDLib::TCard4     __c4Modulus;
        TNode*              __pnodeCur;
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------

inline tCIDLib::TCard4 TKrnlHashMap::c4ElemCount() const
{
    return __c4ElemCount;
}
