//
//  FILE NAME: CIDKernel_File.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_File.Cpp module. This module
//  implements the TKrnlFile class, and encapsulation of the system file
//  APIs.
//
//
//  CAVEATS/GOTCHAS:
//

// ---------------------------------------------------------------------------
//  Forward references
// ---------------------------------------------------------------------------
class   TKrnlTimeStamp;


#pragma pack(push, CIDLIBPACK)

// ---------------------------------------------------------------------------
//   CLASS: TKrnlFile
//  PREFIX: kfl
// ---------------------------------------------------------------------------
class KRNLEXPORT TKrnlFile
{
    public  :
        // -------------------------------------------------------------------
        //  Constructors and destructors
        // -------------------------------------------------------------------
        TKrnlFile();

        TKrnlFile
        (
            const   tCIDLib::Tch* const     pszName
        );

        ~TKrnlFile();


        // -------------------------------------------------------------------
        //  Public operators
        // -------------------------------------------------------------------
        operator tCIDLib::TFileHandle() const;


        // -------------------------------------------------------------------
        //  Public, non-virtual methods
        // -------------------------------------------------------------------
        tCIDLib::TBoolean bValid() const;

        tCIDLib::TVoid Close();

        tCIDLib::TFilePos fposCurSize() const;

        tCIDLib::TFilePos fposFilePtr() const;

        tCIDLib::TFileHandle hflThis() const;

        tCIDLib::TVoid Open
        (
            const   tCIDLib::EAccessModes   eAccess
            , const tCIDLib::ECreateActions eAction
            , const tCIDLib::EFileAttrs     eAttrs
            , const tCIDLib::EFileFlags     eFlags = tCIDLib::EFileFlag_None
        );

        tCIDLib::TVoid Open
        (
            const   tCIDLib::EStdFiles      eStdFile
        );

        const tCIDLib::Tch* pszName() const;

        tCIDLib::TVoid QueryFileInfo
        (
                    TKrnlFileSys::TRawFileFind& fndbToFill
        );

        tCIDLib::TVoid ReadBuffer
        (
                    tCIDLib::TVoid* const   pBuffer
            , const tCIDLib::TCard4         c4ToRead
            ,       tCIDLib::TCard4&        c4Actual = NUL_TCard4
        );

        tCIDLib::TVoid Seek
        (
            const   tCIDLib::TFilePos&      fposOffset
            , const tCIDLib::ESeekFrom      eSeek
            ,       tCIDLib::TFilePos&      fposActual = NUL_TFilePos
        );

        tCIDLib::TVoid SetFileTimes
        (
            const   TKrnlTimeStamp&         ktmsCreate
            , const TKrnlTimeStamp&         ktmsLastAccess
            , const TKrnlTimeStamp&         ktmsLastWrite
        );

        tCIDLib::TVoid SetFileTimes
        (
            const   tCIDLib::TInt8&         i8Create
            , const tCIDLib::TInt8&         i8LastAccess
            , const tCIDLib::TInt8&         i8LastWrite
        );

        tCIDLib::TVoid SetName
        (
            const   tCIDLib::Tch* const     pszNewName
        );

        tCIDLib::TVoid TruncateAt
        (
            const   tCIDLib::TFilePos&      fposPosition
        );

        tCIDLib::TVoid TruncateAt();

        tCIDLib::TVoid WriteBuffer
        (
            const   tCIDLib::TVoid* const   pBuffer
            , const tCIDLib::TCard4         c4ToWrite
            ,       tCIDLib::TCard4&        c4Actual = NUL_TCard4
        );


    private :
        // -------------------------------------------------------------------
        //  Unimplimented constructors and operators
        // -------------------------------------------------------------------
        TKrnlFile(const TKrnlFile&);

        tCIDLib::TVoid operator=(const TKrnlFile&);


        // -------------------------------------------------------------------
        //  Private data members
        //
        //  __hflThis
        //      The handle to the file. Set to 0 during construction and
        //      updated when Open() is called.
        //
        //  __pszName
        //      The name of the file. Set during the construction and never
        //      changed. A buffer is allocated to hold it.
        // -------------------------------------------------------------------
        tCIDLib::TFileHandle    __hflThis;
        tCIDLib::Tch*           __pszName;
};

#pragma pack(pop)


// ---------------------------------------------------------------------------
//  Public operators
// ---------------------------------------------------------------------------
inline TKrnlFile::operator tCIDLib::TFileHandle() const
{
    return __hflThis;
}

// ---------------------------------------------------------------------------
//  Public, non-virtual methods
// ---------------------------------------------------------------------------
inline tCIDLib::TBoolean TKrnlFile::bValid() const
{
    if (__hflThis)
        return kCIDLib::True;
    return kCIDLib::False;
}

inline tCIDLib::TFileHandle TKrnlFile::hflThis() const
{
    return __hflThis;
}

inline const tCIDLib::Tch* TKrnlFile::pszName() const
{
    return __pszName;
}
