//
//  FILE NAME: CIDKernel_ExternalProcess.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 09/13/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_ExternalProcess.Cpp module. This
//  module implements the TKrnlExtProcess class. This class is an abstraction
//  for manipulating external processes that have been started from this
//  process.
//
//  The CIDLib.Dll layer class TExternalProcess uses one of these objects to
//  do its work.
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlExtProcess
//  PREFIX: kextp
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlExtProcess
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlExtProcess();

        ~TKrnlExtProcess();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bIsRunning() const;

        tCIDLib::EPrioClasses ePriorityClass() const;

        tCIDLib::EPrioClasses ePriorityClass
        (
            const   tCIDLib::EPrioClasses   eNewClass
        );

        tCIDLib::EExitCodes eWaitForDeath
        (
            const   tCIDLib::TCard4         c4MilliSecs = kCIDLib::c4MaxWait
        )   const;

        tCIDLib::TVoid Kill();

        tCIDLib::TVoid Start
        (
            const   tCIDLib::Tch* const     pszPath
        );

        tCIDLib::TVoid Start
        (
            const   tCIDLib::Tch* const     pszPath
            , const tCIDLib::Tch**          apszParms
            , const tCIDLib::TCard4         c4ParmCount
            , const tCIDLib::Tch**          apszEnviron
            , const tCIDLib::TCard4         c4EnvironCount
            , const tCIDLib::TBoolean       bDetached = kCIDLib::False
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlExtProcess(const TKrnlExtProcess&);

        tCIDLib::TVoid operator=(const TKrnlExtProcess&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __hprocThis
        //      This is the handle to the process. This is used to interact
        //      with it.
        //
        //  __pidThis
        //      This is the process id of the process.
        // --------------------------------------------------------------------
        tCIDLib::TProcessHandle     __hprocThis;
        tCIDLib::TProcessId         __pidThis;
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------

inline tCIDLib::TVoid TKrnlExtProcess::Start(const tCIDLib::Tch* const pszPath)
{
    Start(pszPath, 0, 0, 0, 0);
}
