//
//  FILE NAME: CIDKernel_EventSemaphore.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_EventSemaphore.Cpp module. This
//  module implements the TKrnlEvent class.
//
//  CAVEATS/GOTCHAS:
//
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlEvent
//  PREFIX: kev
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlEvent
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlEvent();

        TKrnlEvent
        (
            const   tCIDLib::EShareStates   eShared
        );

        TKrnlEvent
        (
            const   tCIDLib::Tch* const     pszName
        );

        ~TKrnlEvent();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bNamed() const;

        tCIDLib::TBoolean bValid() const;

        tCIDLib::TVoid Close();

        tCIDLib::TVoid Create
        (
            const   tCIDLib::EEventStates   eInitState
            , const tCIDLib::EAutoModes     eAutoReset = tCIDLib::EAutoMode_Manual
        );

        tCIDLib::TVoid CreateOrOpen
        (
            const   tCIDLib::EEventStates   eInitState
            , const tCIDLib::EAutoModes     eAutoReset = tCIDLib::EAutoMode_Manual
        );

        tCIDLib::TVoid Duplicate
        (
            const   TKrnlEvent&             kevToDup
        );

        tCIDLib::EShareStates eShareState() const;

        tCIDLib::TVoid Open();

        const tCIDLib::Tch* pszName() const;

        tCIDLib::TVoid Pulse();

        tCIDLib::TVoid Reset();

        tCIDLib::TVoid SetName
        (
            const   tCIDLib::Tch* const     pszNewName
        );

        tCIDLib::TVoid Trigger();

        tCIDLib::TVoid WaitFor
        (
            const   tCIDLib::TCard4         c4MilliSecs = kCIDLib::c4MaxWait
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors or operators
        // --------------------------------------------------------------------
        TKrnlEvent(const TKrnlEvent&);

        tCIDLib::TVoid operator=(const TKrnlEvent&);


        // -------------------------------------------------------------------
        //  Private, non-virtual methods
        // -------------------------------------------------------------------
        tCIDLib::TVoid __CreateNamed
        (
            const   tCIDLib::EEventStates   eInitState
            , const tCIDLib::EAutoModes     eAutoReset
            , const tCIDLib::TBoolean       bFailIfExists
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __eShareState
        //      Indicates whether this event is shareable. If it has a
        //      name, this will be forced to shareable.
        //
        //  __hevThis
        //      This is the handle to the event sem. It is 0 when not valid.
        //
        //  __pszName
        //      The name of the semaphore.
        // --------------------------------------------------------------------
        tCIDLib::EShareStates   __eShareState;
        tCIDLib::TEventHandle   __hevThis;
        tCIDLib::Tch*           __pszName;
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TBoolean TKrnlEvent::bNamed() const
{
    return (__pszName != 0);
}

inline tCIDLib::TBoolean TKrnlEvent::bValid() const
{
    return (__hevThis != kCIDLib::hevInvalid);
}

inline tCIDLib::EShareStates TKrnlEvent::eShareState() const
{
    return __eShareState;
}

inline const tCIDLib::Tch* TKrnlEvent::pszName() const
{
    return __pszName;
}
