//
//  FILE NAME: CIDKernel_ErrorIds.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header defines all of the kernel errors that CIDKernel throws, via
//  the TKrnlError class.
//
//  Platform errors are mapped to these errors. If an error occurs that cannot
//  be mapped, then it is given the generic errcHostErr id. The host error id
//  is made available so it can be formatted into the error string that gets
//  logged, so this provides us with a way to report off the wall errors that
//  are not remotely portable, but which can still happen.
//
//  The TKrnlError class handles the mapping of host errors to these errors.
//

namespace kKrnlErrors
{
    const tCIDLib::TErrCode errcNoError                 = 0;

    // General errors
    const tCIDLib::TErrCode errcHostErr                 = 0xFFFF;
    const tCIDLib::TErrCode errcNotSupported            =    1;
    const tCIDLib::TErrCode errcNoData                  =    2;
    const tCIDLib::TErrCode errcMoreData                =    3;
    const tCIDLib::TErrCode errcOpenFailed              =    4;
    const tCIDLib::TErrCode errcBusy                    =    5;
    const tCIDLib::TErrCode errcWriteFault              =    6;
    const tCIDLib::TErrCode errcReadFault               =    7;
    const tCIDLib::TErrCode errcGenFailure              =    8;
    const tCIDLib::TErrCode errcAlreadyOpen             =    9;
    const tCIDLib::TErrCode errcWrongOS                 =   10;
    const tCIDLib::TErrCode errcAlreadyExists           =   11;
    const tCIDLib::TErrCode errcNegativeResult          =   12;
    const tCIDLib::TErrCode errcTimeout                 =   13;
    const tCIDLib::TErrCode errcAlreadyOwned            =   14;
    const tCIDLib::TErrCode errcNotFound                =   15;
    const tCIDLib::TErrCode errcNullName                =   16;
    const tCIDLib::TErrCode errcTooMany                 =   17;
    const tCIDLib::TErrCode errcAlreadyAllocated        =   18;
    const tCIDLib::TErrCode errcAlreadySet              =   19;
    const tCIDLib::TErrCode errcNotReady                =   20;
    const tCIDLib::TErrCode errcNotOwner                =   21;
    const tCIDLib::TErrCode errcInitError               =   22;
    const tCIDLib::TErrCode errcIndexError              =   23;
    const tCIDLib::TErrCode errcNotAllData              =   24;
    const tCIDLib::TErrCode errcEndOfData               =   25;


    // Access errors
    const tCIDLib::TErrCode errcAccessDenied            =  128;
    const tCIDLib::TErrCode errcInvalidAccess           =  129;
    const tCIDLib::TErrCode errcWriteProtect            =  130;
    const tCIDLib::TErrCode errcSharingViolation        =  131;
    const tCIDLib::TErrCode errcLockViolation           =  132;
    const tCIDLib::TErrCode errcNoAccess                =  133;


    // Device errors
    const tCIDLib::TErrCode errcBadFormat               =  256;
    const tCIDLib::TErrCode errcNotSameDevice           =  257;
    const tCIDLib::TErrCode errcBadUnit                 =  258;
    const tCIDLib::TErrCode errcNoSuchDevice            =  259;
    const tCIDLib::TErrCode errcNegativeSeek            =  260;
    const tCIDLib::TErrCode errcSeekOnDevice            =  261;


    // Environmental errors
    const tCIDLib::TErrCode errcBadEnvironment          =  512;
    const tCIDLib::TErrCode errcCRC                     =  513;
    const tCIDLib::TErrCode errcTooManyCmds             =  514;
    const tCIDLib::TErrCode errcTooManyNames            =  515;
    const tCIDLib::TErrCode errcStackOverflow           =  516;
    const tCIDLib::TErrCode errcDllNotFound             =  517;
    const tCIDLib::TErrCode errcShutdownInProgress      =  518;


    // File system errors
    const tCIDLib::TErrCode errcFileNotFound            = 1024;
    const tCIDLib::TErrCode errcPathNotFound            = 1025;
    const tCIDLib::TErrCode errcTooManyOpenFiles        = 1026;
    const tCIDLib::TErrCode errcInvalidDrive            = 1027;
    const tCIDLib::TErrCode errcCurrentDirectory        = 1028;
    const tCIDLib::TErrCode errcNoMoreFiles             = 1029;
    const tCIDLib::TErrCode errcNotValidDisk            = 1030;
    const tCIDLib::TErrCode errcSectorNotFound          = 1031;
    const tCIDLib::TErrCode errcSeek                    = 1032;
    const tCIDLib::TErrCode errcDiskChange              = 1033;
    const tCIDLib::TErrCode errcDriveLocked             = 1034;
    const tCIDLib::TErrCode errcWrongDisk               = 1035;
    const tCIDLib::TErrCode errcFileExists              = 1036;
    const tCIDLib::TErrCode errcDiskFull                = 1037;
    const tCIDLib::TErrCode errcNoMoreSearchHandles     = 1038;
    const tCIDLib::TErrCode errcBusyDrive               = 1039;
    const tCIDLib::TErrCode errcSameDrive               = 1040;
    const tCIDLib::TErrCode errcNotRootDirectory        = 1041;
    const tCIDLib::TErrCode errcDirNotEmpty             = 1042;
    const tCIDLib::TErrCode errcBadPathName             = 1043;
    const tCIDLib::TErrCode errcUnsupportedFileSystem   = 1044;


    // Formatting errors
    const tCIDLib::TErrCode errcBadJustification        = 1536;


    // Invalid data/params errors
    const tCIDLib::TErrCode errcInvalidFunction         = 2560;
    const tCIDLib::TErrCode errcInvalidHandle           = 2561;
    const tCIDLib::TErrCode errcInvalidData             = 2562;
    const tCIDLib::TErrCode errcBadCommand              = 2563;
    const tCIDLib::TErrCode errcBadLength               = 2564;
    const tCIDLib::TErrCode errcDuplicateName           = 2565; 
    const tCIDLib::TErrCode errcInvalidParameter        = 2566; 
    const tCIDLib::TErrCode errcInvalidName             = 2567; 
    const tCIDLib::TErrCode errcInvalidLevel            = 2568; 
    const tCIDLib::TErrCode errcInsufficientBuffer      = 2569; 
    const tCIDLib::TErrCode errcBadArguments            = 2570; 
    const tCIDLib::TErrCode errcBufferOverflow          = 2571; 


    // Hash map errors
    const tCIDLib::TErrCode errcInvalidIterator         = 2688;
    const tCIDLib::TErrCode errcElemCountUnderflow      = 2689;


    // Memory errors
    const tCIDLib::TErrCode errcNotEnoughMemory         = 3072;
    const tCIDLib::TErrCode errcOutOfMemory             = 3073;
    const tCIDLib::TErrCode errcHostMemPageSz           = 3074;
    const tCIDLib::TErrCode errcInvalidAddress          = 3075;


    // Metrics system errors
    const tCIDLib::TErrCode errcBadMetricCount          = 3100;
    const tCIDLib::TErrCode errcMetricDirFull           = 3101;


    // Network errors
    const tCIDLib::TErrCode errcBadNetPath              = 3584;
    const tCIDLib::TErrCode errcNetworkBusy             = 3585;
    const tCIDLib::TErrCode errcNetNameDeleted          = 3586;
    const tCIDLib::TErrCode errcNetworkAccessDenied     = 3587;
    const tCIDLib::TErrCode errcBadNetName              = 3588;
    const tCIDLib::TErrCode errcInvalidGroupName        = 3589;
    const tCIDLib::TErrCode errcInvalidComputerName     = 3590;
    const tCIDLib::TErrCode errcInvalidEventName        = 3591;
    const tCIDLib::TErrCode errcInvalidDomainName       = 3592;
    const tCIDLib::TErrCode errcInvalidServiceName      = 3593;
    const tCIDLib::TErrCode errcInvalidNetName          = 3594;
    const tCIDLib::TErrCode errcInvalidShareName        = 3595;
    const tCIDLib::TErrCode errcNoNetwork               = 3596;


    // Pipe errors
    const tCIDLib::TErrCode errcPipeConnected           = 4096;
    const tCIDLib::TErrCode errcPipeListening           = 4097;
    const tCIDLib::TErrCode errcBrokenPipe              = 4098;
    const tCIDLib::TErrCode errcBadPipe                 = 4099;
    const tCIDLib::TErrCode errcPipeBusy                = 4100;
    const tCIDLib::TErrCode errcPipeNotConnected        = 4101;


    // Printing errors
    const tCIDLib::TErrCode errcOutOfPaper              = 4608;
    const tCIDLib::TErrCode errcPrintQFull              = 4609;
    const tCIDLib::TErrCode errcNoSpoolSpace            = 4610;
    const tCIDLib::TErrCode errcPrintCancelled          = 4611;
    const tCIDLib::TErrCode errcSpoolNoStartDoc         = 4612;
    const tCIDLib::TErrCode errcSpoolNoAddJob           = 4613;


    // Process registry errors
    const tCIDLib::TErrCode errcProcRegFull             = 4864;
    const tCIDLib::TErrCode errcProcRegIndex            = 4865;
    const tCIDLib::TErrCode errcProcRegUnderflow        = 4866;
    const tCIDLib::TErrCode errcDLLInitFailed           = 4867;


    // Registry errors
    const tCIDLib::TErrCode errcRegistryRecovered       = 5120;
    const tCIDLib::TErrCode errcRegistryCorrupt         = 5121;
    const tCIDLib::TErrCode errcRegistryIOFailed        = 5122;
    const tCIDLib::TErrCode errcNotRegistryFile         = 5123;
    const tCIDLib::TErrCode errcKeyDeleted              = 5124;
    const tCIDLib::TErrCode errcKeyHasChildren          = 5125;


    // Resource name errors
    const tCIDLib::TErrCode errcBadNamedResourceType    = 5248;


    // Security errors
    const tCIDLib::TErrCode errcInvalidPassword         = 5504;
    const tCIDLib::TErrCode errcInvalidPasswordName     = 5505;
    const tCIDLib::TErrCode errcNoSuchPrivilege         = 5506;
    const tCIDLib::TErrCode errcPrivilegeNotHeld        = 5507;
    const tCIDLib::TErrCode errcNoSecurityOnObject      = 5508;
    const tCIDLib::TErrCode errcInvalidAccountName      = 5509;
    const tCIDLib::TErrCode errcInvalidUserName         = 5510;
    const tCIDLib::TErrCode errcMemberOfGroup           = 5511;
    const tCIDLib::TErrCode errcNotMemberOfGroup        = 5512;
    const tCIDLib::TErrCode errcLogonFailed             = 5513;


    // Semaphore, mutex, event errors
    const tCIDLib::TErrCode errcTooManySemRequests      = 5762;
    const tCIDLib::TErrCode errcOwnerDied               = 5763;
    const tCIDLib::TErrCode errcTooManyPosts            = 5764;


    // String errors
    const tCIDLib::TErrCode errcCantLoadStr             = 5794;


    // Synchronization errors
    const tCIDLib::TErrCode errcPossibleDeadlock        = 6016;


    // System information errors
    const tCIDLib::TErrCode errcBadSysColor             = 6272;


    // Time related errors
    const tCIDLib::TErrCode errcBadDayOfWeek            = 6300;


    // Thread and process errors
    const tCIDLib::TErrCode errcInvalidPriority         = 6528;
    const tCIDLib::TErrCode errcStillRunning            = 6529;
    const tCIDLib::TErrCode errcMaxThreadsReached       = 6530;
    const tCIDLib::TErrCode errcAlreadyRunning          = 6531;
    const tCIDLib::TErrCode errcTooManyInstances        = 6532;
    const tCIDLib::TErrCode errcBufOverflow             = 6533;
    const tCIDLib::TErrCode errcNotRunning              = 6534;
    const tCIDLib::TErrCode errcUnknownPrio             = 6535;
    const tCIDLib::TErrCode errcNeverStarted            = 6536;
};
