//
//  FILE NAME: CIDKernel_Environment.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 08/15/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_Environment.Cpp module. This module
//  implements the TKrnlEnvironment class, which is an abstraction for
//  access to the host environment variables. During init, the environmment
//  variables are all loaded up into an internal data structure. They are
//  then accessed via this class.
//
//  CAVEATS/GOTCHAS:
//
//  1)  All operations are synchronized so multiple thread access is not
//      a problem.
//

// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TKrnlCritSec;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlEnvironment
//  PREFIX: kenv
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlEnvironment
{
    public  :
        // --------------------------------------------------------------------
        //  Public types
        // --------------------------------------------------------------------
        class TElem
        {
            public :
                TElem() :

                    pszKey(0)
                    , pszValue(0)
                {
                }

                ~TElem()
                {
                    delete pszKey;
                    delete pszValue;
                }

                tCIDLib::TVoid Set( const   tCIDLib::Tch* const pszTheKey
                                    , const tCIDLib::Tch* const pszTheValue)
                {
                    pszKey = TRawStr::pszReplicate(pszTheKey);
                    pszValue = TRawStr::pszReplicate(pszTheValue);
                }

                tCIDLib::Tch*   pszKey;
                tCIDLib::Tch*   pszValue;

            private :
                TElem(const TElem&);
                tCIDLib::TVoid operator=(const TElem&);
        };


        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlEnvironment();

        ~TKrnlEnvironment();


        // --------------------------------------------------------------------
        //  Public static methods
        // --------------------------------------------------------------------
        static tCIDLib::TVoid Add
        (
            const   tCIDLib::Tch* const     pszKey
            , const tCIDLib::Tch* const     pszNewValue
        );

        static tCIDLib::TBoolean bAddOrUpdate
        (
            const   tCIDLib::Tch* const     pszKey
            , const tCIDLib::Tch* const     pszNewValue
        );

        static tCIDLib::TBoolean bFind
        (
            const   tCIDLib::Tch* const     pszKey
            ,       tCIDLib::Tch* const     pszToFill
            , const tCIDLib::TCard4         c4MaxChars
        );

        static tCIDLib::TCard4 c4Entries();

        static tCIDLib::TCard4 c4QueryState
        (
                    TElem*&                 pelemToFill
        );

        static tCIDLib::TCard4 chCharsInValue
        (
            const   tCIDLib::Tch* const     pszKey
        );

        static tCIDLib::TVoid Lock();

        static tCIDLib::Tch* pszFind
        (
            const   tCIDLib::Tch* const     pszKey
        );

        static tCIDLib::TVoid Unlock();

        static tCIDLib::TVoid Update
        (
            const   tCIDLib::Tch* const     pszKey
            , const tCIDLib::Tch* const     pszNewValue
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlEnvironment(const TKrnlEnvironment&);

        tCIDLib::TVoid operator=(const TKrnlEnvironment&);
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline TKrnlEnvironment::TKrnlEnvironment()
{
}

inline TKrnlEnvironment::~TKrnlEnvironment()
{
}
