//
//    FILE NAME: CIDLib_DevMacros.Hpp
//
//       AUTHOR: Dean Roddey
//
//  CREATE DATE: 11/06/96
//
//    COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This file provides a number of macros that simplify development of new
//  CIDLib classes. They also make it very easy to apply global changes to the
//  way classes are declared.
//
//  CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  This macro is used to check for debug being on or off. This is done for
//  flexibility, instead of doing the ifdef(x) everywhere. For our VC++
//  platform, we drive it off of the project system's _DEBUG define.
// ----------------------------------------------------------------------------
#if     defined(_DEBUG)
#define CID_DEBUG_ON        1
#else
#define CID_DEBUG_ON        0
#endif


// ----------------------------------------------------------------------------
//  Use whatever platform defines are available to set up our own CPU
//  platform include. These control various places where assembly language
//  for the individual platforms can be used.
// ----------------------------------------------------------------------------
#if     defined(_M_IX86)
#define CIDLIB_CPU_X86
#elif   defined(_M_ALPHA)
#define CIDLIB_CPU_ALPHA
#elif   defined(_M_PPC)
#define CIDLIB_CPU_PPC
#endif


// ----------------------------------------------------------------------------
//  This define is used to control conditional code that is dependent upon
//  what 'endianess' the host platform has. If its not little endian, then
//  its big endian.
// ----------------------------------------------------------------------------
#define CIDLIB_LITTLEENDIAN 1


// ----------------------------------------------------------------------------
//  This macro generates a standard set of enum manipulation global functions.
// ----------------------------------------------------------------------------
#define StdEnumTricks(eEnumType) \
inline tCIDLib::TVoid operator++(eEnumType& eVal) \
{ \
    eVal = eEnumType(eVal+1); \
} \
\
inline tCIDLib::TVoid operator++(eEnumType& eVal, int) \
{ \
    eVal = eEnumType(eVal+1); \
} \
\
inline tCIDLib::TVoid operator--(eEnumType& eVal) \
{ \
    eVal = eEnumType(eVal-1); \
} \
\
inline tCIDLib::TVoid operator--(eEnumType& eVal, int) \
{ \
    eVal = eEnumType(eVal-1); \
} \
\
inline eEnumType eEnumMax(eEnumType) \
{ \
    return eEnumType##_Max; \
} \
\
inline eEnumType eEnumMin(eEnumType) \
{ \
    return eEnumType##_Min; \
} \
\
inline tCIDLib::TCard4 c4EnumValueCount(eEnumType) \
{ \
    return tCIDLib::TCard4(eEnumType##_Count); \
} \
\
inline tCIDLib::TBoolean bIsValidEnum(const eEnumType eVal) \
{ \
    if ((eVal < eEnumType##_Min) || (eVal > eEnumType##_Max)) \
        return kCIDLib::False; \
    return kCIDLib::True; \
}


// ----------------------------------------------------------------------------
//  The number of bytes that contain both a1 and a2. a1 should be at the
//  higher address. So it calculates the difference in addresses between the
//  two and then adds in the size of the higher one.
// ----------------------------------------------------------------------------
#define c4BytesIn(a1,a2) \
((((tCIDLib::Tch*)&a1) - ((tCIDLib::Tch*)&a2)) + sizeof(a1))


// ----------------------------------------------------------------------------
//  This macro is our version of the OS/2 FIELDOFFSET macro, which is screwed
//  up because it casts the return to a short.
// ----------------------------------------------------------------------------
#define c4FieldOfs(t,f)     (tCIDLib::TCard4(&(((t *)0)->f)))


// ----------------------------------------------------------------------------
//  This macro is convenient to calculate the number of elements in an
//  array.
// ----------------------------------------------------------------------------
#define c4ArrayElems(a)     (sizeof(a)/sizeof(a[0]))


// ----------------------------------------------------------------------------
//  This little guy is for use by all those time based functions that accept
//  millseconds. So '5 Seconds' will be 5000.
// ----------------------------------------------------------------------------
#define Seconds             *1000


// ----------------------------------------------------------------------------
//  Calculate the number of chars storable in a buffer. This keeps the
//  calculation from being all over the place. The reason for it is that
//  sizeof(buff) is not valid in a UNICode environment. Note that the max
//  chars is 1 less than the full count because it does not include the
//  nul.
// ----------------------------------------------------------------------------
#define c4MaxBufChars(buf)  ((sizeof(buf) / kCIDLib::c4CharBytes)-1)
