//
//  FILE NAME: CIDKernel_CriticalSection.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/01/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_CriticalSection.Cpp module. This
//  module implements the TKrnlCritSec class, which is a low overhead means
//  of protecting critical sections of code or data.  Unlike a mutex, these
//  cannot be shared among processes and cannot timeout, which is why they are
//  speedier.
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlCritSec
//  PREFIX: kcrs
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlCritSec
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlCritSec();

        ~TKrnlCritSec();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bTry();

        tCIDLib::TVoid Enter();

        tCIDLib::TVoid Exit();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlCritSec(const TKrnlCritSec&);

        tCIDLib::TVoid operator=(const TKrnlCritSec&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pData
        //      This is the critical section data. Publically it is just seen
        //      as a void pointer. Internally it is interpreted as required
        //      for the platform.
        // --------------------------------------------------------------------
        tCIDLib::TVoid*         __pData;
};

#pragma pack(pop)
