//
// NAME: CIDKernel_CriticalSection.Cpp
//
// DESCRIPTION:
//
//	This module implements the TKrnlCritSec class, which is a low overhead
//  means of protecting critical sections of code or data.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/01/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"


// ----------------------------------------------------------------------------
//   CLASS: TKrnlCritSec
//  PREFIX: kcrs
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TKrnlCritSec: Constructors and destructors
// ----------------------------------------------------------------------------

TKrnlCritSec::TKrnlCritSec() :

    __pData(0)
{
    __pData = new CRITICAL_SECTION;
    InitializeCriticalSection((CRITICAL_SECTION*)__pData);
}

TKrnlCritSec::~TKrnlCritSec()
{
    if (__pData)
        DeleteCriticalSection((CRITICAL_SECTION*)__pData);
    delete __pData;
}


// ----------------------------------------------------------------------------
//  TKrnlCritSec: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TBoolean TKrnlCritSec::bTry()
{
    if (!TryEnterCriticalSection((CRITICAL_SECTION*)__pData))
        return kCIDLib::False;
    return kCIDLib::True;
}


tCIDLib::TVoid TKrnlCritSec::Enter()
{
    EnterCriticalSection((CRITICAL_SECTION*)__pData);
}


tCIDLib::TVoid TKrnlCritSec::Exit()
{
    LeaveCriticalSection((CRITICAL_SECTION*)__pData);
}
