//
//  FILE NAME: CIDKernel_Constant.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This file is the main constants file of the facility. Since this is
//  the core facility, it has all of the fundamental stuff. We use the name
//  space system to make this stuff fit into the CIDLib.Dll facility's
//  name spaces, since this facility is really hidden from end users.
//
//  CAVEATS/GOTCHAS:
//


namespace   kCIDLib
{
    // ------------------------------------------------------------------------
    //  Our temporary boolean values until we get ANSI boolean.
    // ------------------------------------------------------------------------
    const   tCIDLib::TBoolean       True            = true;
    const   tCIDLib::TBoolean       False           = false;


    // ------------------------------------------------------------------------
    //  These represent the CIDLib release version, and are used anywhere in
    //  the CIDLib code that version is stored, displayed, etc...
    // ------------------------------------------------------------------------
    const tCIDLib::TCard4           c4MajVersion    = 0;
    const tCIDLib::TCard4           c4MinVersion    = 510;
    const tCIDLib::Tch              chRevision      = 'a';
    const tCIDLib::Tch* const       pszVersion      = L"00.510a";


    // ------------------------------------------------------------------------
    //  These are special values that indicate an invalid handle for the
    //  various system handles. These are always used in case the value is
    //  different on some future system.
    // ------------------------------------------------------------------------
    const tCIDLib::TDirHandle       hdirInvalid     = 0;
    const tCIDLib::TEventHandle     hevInvalid      = 0;
    const tCIDLib::TFileHandle      hflInvalid      = tCIDLib::TFileHandle(-1);
    const tCIDLib::TProcessHandle   hprocInvalid    = 0;
    const tCIDLib::TThreadHandle    hthrInvalid     = 0;
    const tCIDLib::TMemHandle       hmemInvalid     = 0;
    const tCIDLib::TModHandle       hmodInvalid     = 0;
    const tCIDLib::TMtxHandle       hmtxInvalid     = 0;
    const tCIDLib::TSemHandle       hsemInvalid     = 0;
    const tCIDLib::TProcessId       pidInvalid      = 0;
    const tCIDLib::TThreadId        tidInvalid      = 0;


    // ------------------------------------------------------------------------
    //  Some very basic constants.
    // ------------------------------------------------------------------------
    const tCIDLib::Tsch             schMaxShortChar = char(0x7F);
    const tCIDLib::Tch              chMaxChar       = 0xFFFF;

    const tCIDLib::TInt1            i1MaxInt        = 127;
    const tCIDLib::TCard1           c1MaxCard       = 0xFF;
    const tCIDLib::TInt2            i2MaxInt        = 32767;
    const tCIDLib::TCard2           c2MaxCard       = 0xFFFF;
    const tCIDLib::TInt4            i4MaxInt        = 2147483647;
    const tCIDLib::TInt8            i8MaxInt        = 9223372036854775807;

    const tCIDLib::TInt1            i1MinInt        = -128;
    const tCIDLib::TInt2            i2MinInt        = -32768;
    const tCIDLib::TInt4            i4MinInt        = -2147483647 - 1;
    const tCIDLib::TInt8            i8MinInt        = -9223372036854775807 - 1;

    const tCIDLib::TFloat4          f4MaxFloat      = 3.402823466e+38F;
    const tCIDLib::TFloat8          f8MaxFloat      = 1.7976931348623158e+308;

    const tCIDLib::TFloat4          f4MinFloat      = 1.175494351e-38F;
    const tCIDLib::TFloat8          f8MinFloat      = 2.2250738585072014e-308;


    // ------------------------------------------------------------------------
    //  The number of bytes in a Tch type.
    // ------------------------------------------------------------------------
    const tCIDLib::TCard4           c4CharBytes     = 2;


    // ------------------------------------------------------------------------
    //  File system constants
    // ------------------------------------------------------------------------
    const tCIDLib::TCard4           c4MaxPathLen    = 260;
    const tCIDLib::Tch              chPathSeparator = L'\\';
    const tCIDLib::Tch* const       szPathSeparator = L"\\";
    const tCIDLib::Tch* const       szBadPathChars  = L"[]/;,|<>^=";
    const tCIDLib::Tch* const       pszAllFilesSpec = L"*.*";
    const tCIDLib::Tch              chExtSeparator  = L'.';
    const tCIDLib::Tch* const       szWhitespace    = L"\r\n\t\a\f\v ";
    const tCIDLib::Tch* const       pszExeExtension = L".Exe";


    // ------------------------------------------------------------------------
    //  Thread related constants
    // ------------------------------------------------------------------------
    const tCIDLib::TCard4           c4MaxPerThreadObjs  = 64;


    // ------------------------------------------------------------------------
    //  Time related constants
    //
    //  The c4XXX time values are in milliseconds. The i8XXX ones are in
    //  100 nanosecond increments.
    // ------------------------------------------------------------------------
    const tCIDLib::TCard4           c4MinYear       = 1601;
    const tCIDLib::TCard4           c4MaxYear       = 2100;
    const tCIDLib::TCard4           c4OneSecond     = 1000;
    const tCIDLib::TCard4           c4OneMinute     = 60 * 1000;
    const tCIDLib::TCard4           c4OneHour       = 60 * c4OneMinute;
    const tCIDLib::TCard4           c4OneDay        = 24 * c4OneHour;
    const tCIDLib::TCard4           c4MaxCard       = 0xFFFFFFFF;

    const tCIDLib::TInt8            i8OneSecond     = 10000000;
    const tCIDLib::TInt8            i8OneMinute     = 60 * i8OneSecond;
    const tCIDLib::TInt8            i8OneHour       = 60 * i8OneMinute;
    const tCIDLib::TInt8            i8OneDay        = 24 * i8OneHour;


    // ------------------------------------------------------------------------
    //  Memory related constants
    // ------------------------------------------------------------------------
    const tCIDLib::TCard4           c4MemPageSize   = 4096;


    // ------------------------------------------------------------------------
    //  Common mathematical constants
    // ------------------------------------------------------------------------
    const tCIDLib::TFloat8          f8PI            = 3.141592653589;
    const tCIDLib::TFloat8          f8PIx2          = 1.570796325;
    const tCIDLib::TFloat8          f8PI_Sqr        = 9.869604379;
    const tCIDLib::TFloat8          f8OneRadian     = 57.296;
    const tCIDLib::TFloat8          f8Log10_PI      = 049.71;
    const tCIDLib::TFloat8          f8Log10_e       = 0.4343;
    const tCIDLib::TFloat8          f8Log10_2       = 0.30103;
    const tCIDLib::TFloat8          f8Log2_e        = 1.4427;
    const tCIDLib::TFloat8          f8Log2_10       = 3.32193;
    const tCIDLib::TFloat8          f8Loge_2        = 0.693147;
    const tCIDLib::TFloat8          f8e             = 2.7183;


    // ------------------------------------------------------------------------
    //  Miscellaneous constants
    // ------------------------------------------------------------------------
    const tCIDLib::TCard4           c4MaxWait       = 0xFFFFFFFF;
    const tCIDLib::TCard4           c4MaxCmdLineParms = 64;
    const tCIDLib::TCard4           c4ClassModulus  = 109;
    const tCIDLib::Tch* const       pszEmptyZStr    = L"";
    const tCIDLib::TCard4           c4MsgIdModulus  = 109;
};
