//
//  FILE NAME: CIDKernel_Console.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_Console.Cpp module. This module
//  implements the TKrnlConsole class, which is a means for doing smart
//  in/output on the raw console where we know its interactive and so
//  command editing and recall is desired.
//
//  CAVEATS/GOTCHAS:
//
//  1)  The console supports redirection, but you have to tell it whether it
//      should honor redirection or not. If not, it will ignore any redirection
//      and always talk to the physical console.
//
//  2)  After a default construction, the Open() method must be called to
//      set up the object.
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlConsole
//  PREFIX: kcon
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlConsole
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlConsole();

        TKrnlConsole
        (
            const   tCIDLib::ETextFormats   eTextFormat
        );

        TKrnlConsole
        (
            const   tCIDLib::TBoolean       bInsertMode
            , const tCIDLib::TCard4         c4MaxRecall
            , const tCIDLib::ETextFormats   eTextFormat
            , const tCIDLib::ERedir         eRedirect
        );

        ~TKrnlConsole();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bAtEnd() const;

        tCIDLib::TCard4 c4GetLine
        (
                    tCIDLib::Tch* const     pszBufToFill
            , const tCIDLib::TCard4         c4MaxChars
            , const tCIDLib::TBoolean       bStripWhitespace = kCIDLib::True
        );

        tCIDLib::Tch chRead();

        tCIDLib::TFilePos fposCurPos() const;

        tCIDLib::TFilePos fposLogicalEnd() const;

        tCIDLib::TFilePos fposPhysicalEnd() const;

        tCIDLib::TFilePos fposSkipForwardBy
        (
            const   tCIDLib::TFilePos       fposSkipBy
        );

        tCIDLib::TFilePos fposSeekToEnd();

        tCIDLib::TVoid Open
        (
            const   tCIDLib::TBoolean       bInsertMode
            , const tCIDLib::TCard4         c4MaxRecall
            , const tCIDLib::ERedir         eRedirect
        );

        tCIDLib::TVoid PutCh
        (
            const   tCIDLib::Tch            chToWrite
        );

        tCIDLib::TVoid PutCh
        (
            const   tCIDLib::Tsch           schToWrite
        );

        tCIDLib::TVoid PutLine
        (
            const   tCIDLib::Tch* const     pszToWrite
        );

        tCIDLib::TVoid PutLine
        (
            const   tCIDLib::Tsch* const    pszToWrite
        );

        tCIDLib::TVoid Reset();

        tCIDLib::Tsch schRead();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlConsole(const TKrnlConsole&);

        tCIDLib::TVoid operator=(const TKrnlConsole&);


        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::Tch __chGet();

        tCIDLib::TVoid __ClearInput
        (
            const   tCIDLib::TCard4         c4CursorPos
            , const tCIDLib::TCard4         c4CharCount
        );

        tCIDLib::TVoid __DelInpChar
        (
                    tCIDLib::Tch* const     pszBuffer
            , const tCIDLib::TCard4         c4CharCount
            , const tCIDLib::TCard4         c4CursorPos
            , const tCIDLib::TBoolean       bUnder
        );

        tCIDLib::TVoid __NextPrevWord
        (
            const   tCIDLib::Tch* const     pszBuffer
            ,       tCIDLib::TCard4&        c4CursorPos
            , const tCIDLib::TCard4         c4CharCount
            , const tCIDLib::Tch            chCur

        );

        tCIDLib::TVoid __NewEntry
        (
            const   tCIDLib::Tch* const     pszBuffer
        );

        tCIDLib::TVoid __OpenFiles
        (
            const   tCIDLib::ERedir         eRedirect
        );

        tCIDLib::TVoid __PutCh
        (
            const   tCIDLib::Tch            chToPut
        );

        tCIDLib::TVoid __PutStr
        (
            const   tCIDLib::Tch*           pszToPut
        );

        tCIDLib::TVoid __PutStr
        (
            const   tCIDLib::Tsch*          pszToPut
        );

        tCIDLib::Tsch __schGet();


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __apszRecallBuf
        //      This is an array of pointers to strings used as a recall
        //      buffer. The constructor indicates how many entries will be
        //      allocated.
        //
        //  __bFirstRecall
        //      This is a trigger to catch when we do the first ever recall
        //      of a command.
        //
        //  __bInsertMode
        //      This indicates whether we are in insert or overwrite mode.
        //
        //  __bRedirIn
        //  __bRedirOut
        //      These are set if the console is using redirected handles,
        //      else cleared if using real console handles. This affects
        //      which read/write functions are used, file or console.
        //
        //  __c4CharCount
        //      The number of characters currently in the input buffer.
        //
        //  __c4CursorPos
        //      The current position of the input cursor in the buffer.
        //
        //  __c4MaxRecall
        //      This is the max number of entries in the recall buffer array.
        //
        //  __c4RecallIndex
        //      The current index into the recall buffer when we are doing
        //      recall.
        //
        //  __eTextFormat
        //      The format that we should expect the text to be in, and the
        //      format that we should write it out as. This only applies if
        //      the console has been redirected.
        //
        //  __fposCurPos
        //      We fake a 'current position' value that is constantly run
        //      up as we read and write, and set back to 0 when the stream
        //      resets us. It really means nothing but we have to maintain
        //      these standard illusion of a stream implementation.
        //
        //  __hflIn
        //  __hflOut
        //      The input and outfile that we use. These are gotten in such
        //      a way that they will not be redirected, i.e. they always use
        //      the console.
        // --------------------------------------------------------------------
        tCIDLib::Tch**          __apszRecallBuf;
        tCIDLib::TBoolean       __bFirstRecall;
        tCIDLib::TBoolean       __bInsertMode;
        tCIDLib::TBoolean       __bRedirIn;
        tCIDLib::TBoolean       __bRedirOut;
        tCIDLib::TCard4         __c4CharCount;
        tCIDLib::TCard4         __c4CursorPos;
        tCIDLib::TCard4         __c4MaxRecall;
        tCIDLib::TCard4         __c4RecallIndex;
        tCIDLib::ETextFormats   __eTextFormat;
        tCIDLib::TFilePos       __fposCurPos;
        tCIDLib::TFileHandle    __hflIn;
        tCIDLib::TFileHandle    __hflOut;
};

#pragma pack(pop)

