//
//  FILE NAME: CIDKernel_BaseInlines.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This file contains some very fundamental inline global functions that
//  are used all over the place.
//
//  CAVEATS/GOTCHAS:
//



// ----------------------------------------------------------------------------
//  These are just simple templates to return the smaller or larger of two
//  quantities (with 'quantity' meaning anything with a < and > operator.)
// ----------------------------------------------------------------------------
template <class T> inline const T& MaxVal(const T& v1, const T& v2)
{
    return (v1 > v2) ? v1 : v2;
}

template <class T> inline const T& MinVal(const T& v1, const T& v2)
{
    return (v1 < v2) ? v1 : v2;
}


// ----------------------------------------------------------------------------
//  Tests whether the value is within the min/max values passed, inclusive.
// ----------------------------------------------------------------------------
template <class T> inline tCIDLib::TBoolean bInRange(const T& val, const T& min, const T& max)
{
    if ((val < min) || (val > max))
        return kCIDLib::False;
    return kCIDLib::True;
}


// ----------------------------------------------------------------------------
//  Swaps two values of any type
// ----------------------------------------------------------------------------
template <class T> inline tCIDLib::TVoid Swap(T& v1, T& v2)
{
    T vTmp = v1;
    v1 = v2;
    v2 = vTmp;
}


// ----------------------------------------------------------------------------
//  Calculates the offset between two addresses. Keeps the caller from having
//  to do the casting. p2 should be higher in memory.
// ----------------------------------------------------------------------------
template <class T> inline tCIDLib::TCard4 c4AdrDiff(const T* p1, const T* p2)
{
    return ((tCIDLib::TCard1*)p2) - ((tCIDLib::TCard1*)p1);
}


// ----------------------------------------------------------------------------
//  This template offsets a pointer by an integral value and casts the return
//  back to the original type.
// ----------------------------------------------------------------------------
template <class T> inline const T*
pOffsetPtr(const T* const pToOffset, const tCIDLib::TInt4 i4Ofs)
{
    return (const T*) (((tCIDLib::TCard1*)pToOffset)+i4Ofs);
}

template <class T> inline T*
pOffsetPtr(T* const pToOffset, const tCIDLib::TInt4 i4Ofs)
{
    return (T*) (((tCIDLib::TCard1*)pToOffset)+i4Ofs);
}

template <class T> inline const T*
pOffsetPtr(const T* const pToOffset, const tCIDLib::TCard4 c4Ofs)
{
    return (const T*) (((tCIDLib::TCard1*)pToOffset)+c4Ofs);
}

template <class T> inline T*
pOffsetPtr(T* const pToOffset, const tCIDLib::TCard4 c4Ofs)
{
    return (T*) (((tCIDLib::TCard1*)pToOffset)+c4Ofs);
}

template <class T> inline const T*
pOffsetPtr(const T* const pToOffset, const unsigned int uiOfs)
{
    return (const T*) (((tCIDLib::TCard1*)pToOffset)+uiOfs);
}

template <class T> inline T*
pOffsetPtr(T* const pToOffset, const unsigned int uiOfs)
{
    return (T*) (((tCIDLib::TCard1*)pToOffset)+uiOfs);
}
