//
//  FILE NAME: CIDKernel_.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main internal header for the facility. It includes the main
//  public header, and any internal ones that are needed. It also includes
//  the system headers, which are only used internally.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Include the Windoze headers for internal use
// ----------------------------------------------------------------------------
#include    <windows.h>


// ----------------------------------------------------------------------------
//  Undefine some of the stupid W/A mapping macros so they don't rename our
//  methods.
// ----------------------------------------------------------------------------
#undef      CopyFile
#undef      DeleteFile
#undef      LoadBitmap
#undef      RemoveDirectory


// ----------------------------------------------------------------------------
//  And also our own public header and any internal headers
// ----------------------------------------------------------------------------
#include    "CIDKernel.Hpp"
#include    "CIDKernel_TextXlat.Hpp"


// ----------------------------------------------------------------------------
//  The internal types and constants namespaces
// ----------------------------------------------------------------------------
namespace kCIDKernel_
{
    //
    //  These are the strings used in any popups that are done. These are
    //  default values that will be left if the load of these strings from
    //  resources fails.
    //
    const tCIDLib::Tch* const pszTitle1 = L"CIDLib Kernel Abstraction Layer";
    const tCIDLib::Tch* const pszTitle2 = L"Copyright (c) CIDLib 1992..1997";
};

namespace tCIDKernel_
{
    typedef tCIDLib::TVoid (*TKModInitTermFuncPtr)
    (
        const   tCIDLib::EInitTerm      eInitTerm
        , const tCIDLib::EGlobalStates  eGlobals
        , const tCIDLib::TModHandle     hmodInit
        , const tCIDLib::TCard4         c4MaxChars
        ,       tCIDLib::Tch* const     pszFailReason
    );

    // ------------------------------------------------------------------------
    //  This is a small record used by the module init scheme
    // ------------------------------------------------------------------------
    #pragma pack(push, CIDLIBPACK)
    struct TKModuleInitTermRec
    {
        TKModInitTermFuncPtr            pfnInitTermFunc;
        const tCIDLib::Tch*             pszText;
    };
    #pragma pack(pop)
};


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TModHandle  _hmodKernel;


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_Error.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermError
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_Environment.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermEnvironment
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_Locale.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermLocale
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_MemCheck.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermMemCheck
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_Metrics.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermMetrics
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_ProcessRegistry.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermProcessRegistry
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason

);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_StackDump.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermStackDump
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDKernel_SystemInfo.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermSysInfo
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const tCIDLib::TModHandle     hmodKernel
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Macros to simplify the emergency popup operation internally
// ----------------------------------------------------------------------------
#define _ERRPOPUP_(msg,err) \
TKrnlPopup::Show \
( \
    __FILE__ \
    , __LINE__ \
    , kCIDKernel_::pszTitle1 \
    , kCIDKernel_::pszTitle1 \
    , 0 \
    , err \
    , 0 \
    , msg \
    , kCIDLib::pszEmptyZStr \
);

#define _KRNLERRPOPUP_(msg,kerr) \
TKrnlPopup::Show \
( \
    __FILE__ \
    , __LINE__ \
    , kCIDKernel_::pszTitle1 \
    , kCIDKernel_::pszTitle1 \
    , 0 \
    , kerr.errcId() \
    , kerr.errcHostId() \
    , msg \
    , kCIDLib::pszEmptyZStr \
);

#define _MSGPOPUP_(msg) \
TKrnlPopup::Show \
( \
    __FILE__ \
    , __LINE__ \
    , kCIDKernel_::pszTitle1 \
    , kCIDKernel_::pszTitle2 \
    , 0 \
    , 0 \
    , 0 \
    , msg \
    , kCIDLib::pszEmptyZStr \
);
