//
//  FILE NAME: CIDKernel.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main public header for the facility. It is the single point
//  of contact for the outside world. By including it, they get what we
//  have to offer. It also insures consistent order of inclusion which
//  is needed for the precompiled headers stuff to work.
//
//  CAVEATS/GOTCHAS:
//

#if         !defined(_CIDKERNEL_)
#define     _CIDKERNEL_


// ----------------------------------------------------------------------------
//  Provide null references for some classes
// ----------------------------------------------------------------------------
#define     NUL_TKrnlConsole        (*(TKrnlConsole*)0)
#define     NUL_TKrnlCritSec        (*(TKrnlCritSec*)0)
#define     NUL_TKrnlEvent          (*(TKrnlEvent*)0)
#define     NUL_TKrnlFile           (*(TKrnlFile*)0)
#define     NUL_TKrnlModule         (*(TKrnlModule*)0)
#define     NUL_TKrnlMutex          (*(TKrnlMutex*)0)
#define     NUL_TKrnlRscName        (*(TKrnlRscName*)0)
#define     NUL_TKrnlSafeCounter    (*(TKrnlSafeCounter*)0)
#define     NUL_TKrnlSemaphore      (*(TKrnlSemaphore*)0)
#define     NUL_TKrnlSharedMemBuf   (*(TKrnlSharedMemBuf*)0)
#define     NUL_TKrnlTimeStamp      (*(TKrnlTimeStamp*)0)
#define     NUL_TKrnlThread         (*(TKrnlThread*)0)


// ----------------------------------------------------------------------------
//  Define the packing size for our code. This is used in all of the pack
//  pragmas that surround CIDLib classes. This lets us change our packing
//  for platforms, without having to use command line switches that make it
//  hard to mix code from different sources sometimes.
// ----------------------------------------------------------------------------
#define     CIDLIBPACK  4


// ----------------------------------------------------------------------------
//  Subinclude the two really fundamental headers that must be before
//  everything.
// ----------------------------------------------------------------------------
#include    "CIDKernel_DevMacros.Hpp"
#include    "CIDKernel_Type.Hpp"
#include    "CIDKernel_Constant.Hpp"
#include    "CIDKernel_BaseInlines.Hpp"
#include    "CIDKernel_UniCode.Hpp"


// ----------------------------------------------------------------------------
//  Do the standard enum tricks for some of our enums
// ----------------------------------------------------------------------------
#if !defined(CIDKRNL_NOCLASSES)
StdEnumTricks(tCIDLib::EAutoModes)
StdEnumTricks(tCIDLib::EDeleteModes)
StdEnumTricks(tCIDLib::EDriveTypes)
StdEnumTricks(tCIDLib::EEnds)
StdEnumTricks(tCIDLib::EForceOpts)
StdEnumTricks(tCIDLib::EHJustify)
StdEnumTricks(tCIDLib::EInitTerm)
StdEnumTricks(tCIDLib::EMonths)
StdEnumTricks(tCIDLib::EPrioClasses)
StdEnumTricks(tCIDLib::EPrioLevels)
StdEnumTricks(tCIDLib::EProcStates)
StdEnumTricks(tCIDLib::ESeverities)
StdEnumTricks(tCIDLib::ESignPositions)
StdEnumTricks(tCIDLib::ESymmetries)
StdEnumTricks(tCIDLib::ETriStates)
StdEnumTricks(tCIDLib::EVJustify)
StdEnumTricks(tCIDLib::EWeekDays)
#endif


// ----------------------------------------------------------------------------
//  <TBD> This is a hack to get around a problem with VC++ 5.0. Remove it when
//  its fixed.
// ----------------------------------------------------------------------------
using namespace tCIDLib;
using namespace kCIDLib;


// ----------------------------------------------------------------------------
//  Set up our import/export attributes
// ----------------------------------------------------------------------------
#if     defined(PROJ_CIDKERNEL)
#define KRNLEXPORT  DLLEXPORT
#define KRNLEXTERN
#else
#define KRNLEXPORT  DLLIMPORT
#define KRNLEXTERN  extern
#endif


// ----------------------------------------------------------------------------
//  Now subinclude our other headers
// ----------------------------------------------------------------------------
#include    "CIDKernel_ErrorIds.Hpp"
#include    "CIDKernel_ResourceIds.H"

#include    "CIDKernel_Error.Hpp"
#include    "CIDKernel_RawBits.Hpp"
#include    "CIDKernel_RawMemory.Hpp"
#include    "CIDKernel_RawString.Hpp"
#include    "CIDKernel_Environment.Hpp"
#include    "CIDKernel_ResourceName.Hpp"
#include    "CIDKernel_CriticalSection.Hpp"
#include    "CIDKernel_SharedMemBuf.Hpp"
#include    "CIDKernel_EventSemaphore.Hpp"
#include    "CIDKernel_MutexSemaphore.Hpp"
#include    "CIDKernel_Semaphore.Hpp"
#include    "CIDKernel_ExternalProcess.Hpp"
#include    "CIDKernel_FileSystem.Hpp"
#include    "CIDKernel_File.Hpp"
#include    "CIDKernel_HashMap.Hpp"
#include    "CIDKernel_HeapJanitor.Hpp"
#include    "CIDKernel_Locale.Hpp"
#include    "CIDKernel_LockJanitors.Hpp"
#include    "CIDKernel_LowLevelPopUp.Hpp"
#include    "CIDKernel_MathLib.Hpp"
#include    "CIDKernel_Metrics.Hpp"
#include    "CIDKernel_Module.Hpp"
#include    "CIDKernel_ObjJanitor.Hpp"
#include    "CIDKernel_ProcessRegistry.Hpp"
#include    "CIDKernel_Registry.Hpp"
#include    "CIDKernel_SafeCounter.Hpp"
#include    "CIDKernel_SearchNSort.Hpp"
#include    "CIDKernel_SysException.Hpp"
#include    "CIDKernel_SystemInfo.Hpp"
#include    "CIDKernel_Time.Hpp"
#include    "CIDKernel_Thread.Hpp"

#include    "CIDKernel_Console.Hpp"


// ----------------------------------------------------------------------------
//  Export the kernel module object.
// ----------------------------------------------------------------------------
extern KRNLEXPORT TKrnlModule kmodCIDKernel;

#endif
