//
// NAME: CIDFractal_Type.h
//
// DESCRIPTION:
//
//  This is the type header for the fractal engine facility. This guy holds
//  facility wide types and constants.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/22/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//

namespace tCIDFractal
{
    // ------------------------------------------------------------------------
    //  The various sizes that the data cache can be set up to hold. Each
    //  type of fractal knows size cache elements it needs to have
    //  available to store its per pixel values.
    // ------------------------------------------------------------------------
    enum EElemTypes
    {
        EElemType_Card1
        , EElemType_Card2
        , EElemType_Card4
        , EElemType_Float4
        , EElemType_Float8

        , EElemTypes_Count
        , EElemTypes_Min            = EElemType_Card1
        , EElemTypes_Max            = EElemType_Float8
    };


    // ------------------------------------------------------------------------
    //  The types of coloring schemes for prisoner points.
    // ------------------------------------------------------------------------
    enum EInsideMaps
    {
        EInsideMap_Prisoner
        , EInsideMap_ClrIndex
        , EInsideMap_MaxIterations
        , EInsideMap_ZMag

        , EInsideMaps_Count
        , EInsideMaps_Min           = EInsideMap_Prisoner
        , EInsideMaps_Max           = EInsideMap_ZMag
    };


    // ------------------------------------------------------------------------
    //  The types of coloring schemes for escape points.
    // ------------------------------------------------------------------------
    enum EOutsideMaps
    {
        EOutsideMap_Iterations
        , EOutsideMap_ClrIndex
        , EOutsideMap_RealMag
        , EOutsideMap_ImaginaryMag

        , EOutsideMaps_Count
        , EOutsideMaps_Min          = EOutsideMap_Iterations
        , EOutsideMaps_Max          = EOutsideMap_ImaginaryMag
    };
};


#if !defined(CIDFRACTAL_NOCLASSES)
EnumStreamMacros(tCIDFractal::EElemTypes)
EnumStreamMacros(tCIDFractal::EInsideMaps)
EnumStreamMacros(tCIDFractal::EOutsideMaps)
#endif


// ----------------------------------------------------------------------------
//  Apply the standard enum tricks to selected enums
// ----------------------------------------------------------------------------
StdEnumTricks(tCIDFractal::EInsideMaps)
StdEnumTricks(tCIDFractal::EOutsideMaps)
StdEnumTricks(tCIDFractal::EElemTypes)
