//
// NAME: CIDFractal_Type.Cpp
//
// DESCRIPTION: 
//
//  This module provides all of the facility type formatting code, for the
//  types defined in CIDFractal_Type.Hpp.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/27/95
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include 	"CIDFractal_.Hpp"


// -----------------------------------------------------------------------------
//  Local, static data
//
//  __aetmInsideMap
//      The strings that describe the values of the inside map enum
// -----------------------------------------------------------------------------
static tCIDLib::TEnumTextMap<tCIDFractal::EInsideMaps>  __aetmInsideMap[] =
{
      { tCIDFractal::EInsideMap_Prisoner        , kFractMsgs::midIMap_Prisoner  , L"" }
    , { tCIDFractal::EInsideMap_ClrIndex        , kFractMsgs::midIMap_ClrIndex  , L"" }
    , { tCIDFractal::EInsideMap_MaxIterations   , kFractMsgs::midIMap_MaxIters  , L"" }
    , { tCIDFractal::EInsideMap_ZMag            , kFractMsgs::midIMap_ZMag      , L"" }
};

static tCIDLib::TEnumTextMap<tCIDFractal::EOutsideMaps>  __aetmOutsideMap[] =
{
      { tCIDFractal::EOutsideMap_Iterations     , kFractMsgs::midOMap_Iterations, L"" }
    , { tCIDFractal::EOutsideMap_ClrIndex       , kFractMsgs::midOMap_ClrIndex  , L"" }
    , { tCIDFractal::EOutsideMap_RealMag        , kFractMsgs::midOMap_Real      , L"" }
    , { tCIDFractal::EOutsideMap_ImaginaryMag   , kFractMsgs::midOMap_Imaginary , L"" }
};


// ----------------------------------------------------------------------------
//  Intra-facility methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid
_InitTermThisType(  const   tCIDLib::EInitTerm      eInitTerm
                    , const tCIDLib::EGlobalStates  eGlobals
                    , const TModule&                modInit
                    , const tCIDLib::TCard4         c4MaxChars
                    ,       tCIDLib::Tch* const     pszFailReason)
{
    const tCIDLib::Tch* pszPhase = modInit.pszLoadCIDMsg(kFractMsgs::midGen_Unknown);
    try
    {
        if ((eInitTerm == tCIDLib::EInitTerm_Initialize)
        &&  (eGlobals == tCIDLib::EGlobalState_Before))
        {
            //
            //  Load up all of our strings. We just set up const pointers
            //  to the text, since they are already mapped into the address
            //  space anyway.
            //
            tCIDLib::TCard4         c4Index;
            const tCIDLib::Tch*     pszTmp;

            // Load up the inside map enum strings
            for (c4Index = 0; c4Index < c4ArrayElems(__aetmInsideMap); c4Index++)
            {
                pszTmp = modInit.pszLoadCIDMsg(__aetmInsideMap[c4Index].midText);
                if (pszTmp)
                    __aetmInsideMap[c4Index].pszText = pszTmp;
            }

            // Load up the outside map enum strings
            for (c4Index = 0; c4Index < c4ArrayElems(__aetmOutsideMap); c4Index++)
            {
                pszTmp = modInit.pszLoadCIDMsg(__aetmOutsideMap[c4Index].midText);
                if (pszTmp)
                    __aetmOutsideMap[c4Index].pszText = pszTmp;
            }
        }
    }

    catch(...)
    {
        TRawStr::CopyStr(pszFailReason, pszPhase, c4MaxChars);
        throw;
    }
}



// -----------------------------------------------------------------------------
//  Global functions
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: operator<<
//
// DESCRIPTION:
//
//  These are all formatting operators for this facility's enums.
// ---------------------------------------
//   INPUT: eXXX is the enum value to format.
//
//  OUTPUT: strmToWriteTo is the stream to format the enum to.
//
//  RETURN: A reference to the destination text stream.
//
TTextStream&
operator<<(TTextStream& strmToWriteTo, const tCIDFractal::EElemTypes eElemType)
{
    switch(eElemType)
    {
        case tCIDFractal::EElemType_Card1 :
            strmToWriteTo << L"TCard1";
            break;

        case tCIDFractal::EElemType_Card2 :
            strmToWriteTo << L"TCard2";
            break;

        case tCIDFractal::EElemType_Card4 :
            strmToWriteTo << L"TCard4";
            break;

        case tCIDFractal::EElemType_Float4 :
            strmToWriteTo << L"TFloat4";
            break;

        case tCIDFractal::EElemType_Float8 :
            strmToWriteTo << L"TFloat8";
            break;

        default :
            facCIDFractal.LogErr
            (
                __FILE__
                , __LINE__
                , kFractErrs::errcGen_InvalidValue
                , tCIDLib::ESev_ProcessFatal
                , tCIDLib::EClass_Unknown
                , TInteger(eElemType)
                , TString(L"EElemTypes")
            );
            break;
    }
    return strmToWriteTo;
}

TTextStream&
operator<<(TTextStream& strmToWriteTo, const tCIDFractal::EInsideMaps eInsideMap)
{
    if ((eInsideMap < tCIDFractal::EInsideMaps_Min)
    ||  (eInsideMap < tCIDFractal::EInsideMaps_Max))
    {
        facCIDFractal.LogErr
        (
            __FILE__
            , __LINE__
            , kFractErrs::errcGen_InvalidValue
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_Unknown
            , TInteger(eInsideMap)
            , TString(L"EInsideMaps")
        );
    }
    strmToWriteTo << __aetmInsideMap[eInsideMap].pszText;
    return strmToWriteTo;
}

TTextStream&
operator<<(TTextStream& strmToWriteTo, const tCIDFractal::EOutsideMaps eOutsideMap)
{
    if ((eOutsideMap < tCIDFractal::EOutsideMaps_Min)
    ||  (eOutsideMap < tCIDFractal::EOutsideMaps_Max))
    {
        facCIDFractal.LogErr
        (
            __FILE__
            , __LINE__
            , kFractErrs::errcGen_InvalidValue
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_BadParms
            , TInteger(eOutsideMap)
            , TString(L"EOutsideMaps")
        );
    }
    strmToWriteTo << __aetmOutsideMap[eOutsideMap].pszText;
    return strmToWriteTo;
}
