//
// NAME: CIDFrac_StdThread.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDFrac_StdThread.Cpp module, which implements
//  a derivative of the TThread class that is used by the single threaded and
//  multi-threaded calculation engine derivatives. This thread demonstrates
//  now any any derivative would want to implement their threads. They would
//  just do something different perhaps, like send the calculation request to
//  another machine.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/14/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TFracCalcEngine;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TStdFracThread
//  PREFIX: thr
// -----------------------------------------------------------------------------
class CIDFRACTALEXP TStdFracThread : public TThread
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TStdFracThread();

        TStdFracThread
        (
                    TFracCalcEngine* const  pfcengParent
        );

        ~TStdFracThread();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid SetCalcEngine
        (
                    TFracCalcEngine* const  pfcengParent
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::EExitCodes _eProcess();


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TStdFracThread(const TStdFracThread&);

        tCIDLib::TVoid operator=(const TStdFracThread&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __pfcengParent
        //      This is our 'parent' calculation engine. We save this point
        //      to the engine when we are created and call back on it to get
        //      our marching orders and to store our results.
        // ---------------------------------------------------------------------
        TFracCalcEngine*        __pfcengParent;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TStdFracThread,TThread)
};

#pragma pack(pop)
