//
// NAME: CIDFrac_StdThread.Cpp
//
// DESCRIPTION: 
//
//  This module implements a standard thread derivative that is used by both
//  the multi and single threaded calculation engines to distribute the
//  calculation work.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/14/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//

// -----------------------------------------------------------------------------
//  Facility includes
// -----------------------------------------------------------------------------
#include    "CIDFractal_.Hpp"


// -----------------------------------------------------------------------------
//  Do our standard members macro
// -----------------------------------------------------------------------------
RTTIData2(TStdFracThread,TThread)


// -----------------------------------------------------------------------------
//  Local data
//
//  __unamThreads
//      This is a unique name object used to apply unique names to each
//      thread, since we don't want the outside world to have to come up
//      with unique names.
// -----------------------------------------------------------------------------
static  TUniqueName         __unamThreads(L"FractThread_%(1)");



// -----------------------------------------------------------------------------
//  Local functions
// -----------------------------------------------------------------------------

static TString __strNextThreadName()
{
    return __unamThreads.strQueryNewName();
}



// -----------------------------------------------------------------------------
//   CLASS: TStdFracThread
//  PREFIX: thr
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TStdFracThread: Constructors and destructors
// -----------------------------------------------------------------------------

TStdFracThread::TStdFracThread() :

    TThread(__strNextThreadName())
    , __pfcengParent(0)
{
}

TStdFracThread::TStdFracThread(TFracCalcEngine* const pfcengParent) :

    TThread(__strNextThreadName())
    , __pfcengParent(pfcengParent)
{
}

TStdFracThread::~TStdFracThread()
{
}


// -----------------------------------------------------------------------------
//  TStdFracThread: Public, non-virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
TStdFracThread::SetCalcEngine(TFracCalcEngine* const  pfcengParent)
{
    __pfcengParent = pfcengParent;
}


// -----------------------------------------------------------------------------
//  TStdFracThread: Protected, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::EExitCodes TStdFracThread::_eProcess()
{
    // Let our caller go
    Sync();

    TFPoint     pntFract;
    TQ1Point    pntPixel;
    while (1)
    {
        //
        //  Get another point to work on. If the calc engine has not more
        //  work to give us, we kill ourself (cause we hate that.)
        //
        if (!__pfcengParent->bGetNextPoint(pntPixel, pntFract))
            break;

        //
        //  Calculate the value for this pixel and insert it into the
        //  cache.
        //
        __pfcengParent->CalcPixel(pntPixel, pntFract);
    }
    return tCIDLib::EExit_Normal;
}
