//
// NAME: CIDFrac_SingleEngine.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDFrac_SingleEngine.Cpp module, which
//  implements a simple derivative of the base calculation engine. This
//  one just implements a single threaded engine.
//
//  Basically all the added value we provide is to kick off the thread
//  and manage it upon request from the outside.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/15/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TFracSingleEngine
// PREFIX: fceng
// -----------------------------------------------------------------------------
class CIDFRACTALEXP TFracSingleEngine : public TFracCalcEngine
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TFracSingleEngine();

        TFracSingleEngine
        (
            const   TSize&                  szPelImage
            , const TFArea&                 fareaImage
            ,       TBaseFractal* const     pfracToAdopt
            ,       TStatusController* const pstatcToAdopt
        );

        TFracSingleEngine
        (
            const   TFracSingleEngine&      fcengToCopy
        );

        ~TFracSingleEngine();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid StartProcessing();

        tCIDLib::TVoid StopProcessing();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid Setup
        (
            const   TSize&                  szPelImage
            , const TFArea&                 fareaImage
            ,       TBaseFractal* const     pfracToAdopt
            ,       TStatusController* const pstatcToAdopt
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TFracSingleEngine& operator=(const TFracSingleEngine&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __thrWorker
        //      This is the thread object that we create to do our work.
        //      Notice that is of a custom derivative type of thread that
        //      is canned to work with us.
        // ---------------------------------------------------------------------
        TStdFracThread          __thrWorker;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFracSingleEngine,TFracCalcEngine)
        DefPolyDup(TFracSingleEngine)
};

#pragma pack(pop)
