//
// NAME: CIDFrac_SingleEngine.Cpp
//
// DESCRIPTION: 
//
//  This module implements the TFracSingleEngine class, which provides a
//  simple, single thread derivative of the base calculation engine class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/15/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Facility includes
// -----------------------------------------------------------------------------
#include    "CIDFractal_.Hpp"


// -----------------------------------------------------------------------------
//  Do our standard members macro
// -----------------------------------------------------------------------------
RTTIData2(TFracSingleEngine,TFracCalcEngine)



// -----------------------------------------------------------------------------
//   CLASS: TFracSingleEngine
//  PREFIX: fceng
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TFracSingleEngine: Constructors and Destructors
// -----------------------------------------------------------------------------

TFracSingleEngine::TFracSingleEngine()
{
    __thrWorker.SetCalcEngine(this);
}

TFracSingleEngine::TFracSingleEngine(const   TSize&              szPelImage
                                     , const TFArea&             fareaSpace
                                     ,       TBaseFractal* const pfracToAdopt
                                     , TStatusController* const  pstatcToAdopt) :
    TFracCalcEngine
    (
        szPelImage
        , fareaSpace
        , pfracToAdopt
        , pstatcToAdopt
    )
{
    __thrWorker.SetCalcEngine(this);
}

TFracSingleEngine::TFracSingleEngine(const TFracSingleEngine& fcengToCopy) :

    TFracCalcEngine(fcengToCopy)
{
    __thrWorker.SetCalcEngine(this);
}

TFracSingleEngine::~TFracSingleEngine()
{
}


// -----------------------------------------------------------------------------
//  TFracSingleEngine: Public, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TFracSingleEngine::StartProcessing()
{
    __thrWorker.Start();
}

tCIDLib::TVoid TFracSingleEngine::StopProcessing()
{
    __thrWorker.RequestShutdown(30 Seconds);
}



// -----------------------------------------------------------------------------
//  TFracSingleEngine: Public, non-virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
TFracSingleEngine::Setup(   const   TSize&                  szPelImage
                            , const TFArea&                 fareaImage
                            ,       TBaseFractal* const     pfracToAdopt
                            ,       TStatusController* const pstatcToAdopt)
{
    // Pass on the information to our parent
    _SetImageInfo(szPelImage, fareaImage, pfracToAdopt, pstatcToAdopt);
}


// -----------------------------------------------------------------------------
//  TFracSingleEngine: Protected, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
TFracSingleEngine::_StreamFrom(TBinaryStream& strmToReadFrom)
{
    TParent::_StreamFrom(strmToReadFrom);
}

tCIDLib::TVoid
TFracSingleEngine::_StreamTo(TBinaryStream& strmToWriteTo) const
{
    TParent::_StreamTo(strmToWriteTo);
}
