//
// NAME: CIDFrac_MultiEngine.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDFrac_MultiEngine.Cpp module, which
//  implements a simple derivative of the base calculation engine. This
//  one implements a multi-threaded threaded engine.
//
//  Basically all the added value we provide is to kick off the threads
//  and manage them upon request from the outside.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/15/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TFracMTEngine
// PREFIX: fceng
// -----------------------------------------------------------------------------
class CIDFRACTALEXP TFracMTEngine : public TFracCalcEngine
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TFracMTEngine();

        TFracMTEngine
        (
            const   TSize&                  szPelImage
            , const TFArea&                 fareaImage
            ,       TBaseFractal* const     pfracToAdopt
            , const tCIDLib::TCard4         c4ThreadCount
            ,       TStatusController* const pstatcToAdopt
        );

        TFracMTEngine
        (
            const   TFracMTEngine&          fcengToCopy
        );

        ~TFracMTEngine();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid StartProcessing();

        tCIDLib::TVoid StopProcessing();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4 c4ThreadCount() const;

        tCIDLib::TVoid Setup
        (
            const   TSize&                  szPelImage
            , const TFArea&                 fareaImage
            ,       TBaseFractal* const     pfracToAdopt
            , const tCIDLib::TCard4         c4ThreadCount
            ,       TStatusController* const pstatcToAdopt
        );



    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TFracMTEngine& operator=(const TFracMTEngine&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __c4ThreadCount
        //      This is the number of threads that this engine is running.
        //
        //  __pthrWorkers
        //      This is the array of thread objects that we create to do
        //      our work. Notice that is of a custom derivative type of thread
        //      that is canned to work with us.
        // ---------------------------------------------------------------------
        tCIDLib::TCard4             __c4ThreadCount;
        TStdFracThread*             __pthrWorkers;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFracMTEngine,TFracCalcEngine)
        DefPolyDup(TFracMTEngine)
};

#pragma pack(pop)



// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------

inline tCIDLib::TCard4 TFracMTEngine::c4ThreadCount() const
{
    return __c4ThreadCount;
}
