//
// NAME: CIDFractal_Mandelbrot.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the module CIDFractal_Mandelbrot.Cpp. This module
//  implements the TMandelbrot class.
//
//  TMandelbrot is derived from TEscapeFractal, which is the base class of
//  those fractals that are created via an escape time iteration formula.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/24/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//  1)  The z and c components are not class members because they are
//      calculated for each pixel from the fratal coordinates.
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TFracCache;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TMandelbrot
// PREFIX: frac
// -----------------------------------------------------------------------------
class CIDFRACTALEXP TMandelbrot : public TEscapeFractal
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TMandelbrot();

        TMandelbrot
        (
            const   TMandelbrot&            fracToCopy
        );

        TMandelbrot
        (
            const   tCIDLib::TCard4         c4MaxIterations
        );

        ~TMandelbrot() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TMandelbrot& operator=
        (
            const   TMandelbrot&            fracToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, static methods
        // ---------------------------------------------------------------------
        static tCIDLib::TCard4 ASMCALL c4MandelLoop
        (
            const   tCIDLib::TFloat8        f8ZReal
            , const tCIDLib::TFloat8        f8ZImag
            , const tCIDLib::TFloat8        f8CReal
            , const tCIDLib::TFloat8        f8CImag
            , const tCIDLib::TCard4         c4MaxIter
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid CalcPixel
        (
            const   TQ1Point&               pntPixel
            , const TFPoint&                pntFractal
            ,       TFracCache&             fcachToStoreIn
        )   const;

        TFArea fareaDefSpace() const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TMandelbrot,TEscapeFractal)
        DefPolyDup(TMandelbrot)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Public, inherited methods
// -----------------------------------------------------------------------------
inline TFArea TMandelbrot::fareaDefSpace() const
{
    return TFArea(-2.1, 1.2, -1.5, 1.5);
}
