//
// NAME: CIDFractal_Julia.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the module CIDFractal_Julia.Cpp. This module
//  implements the TJulia class and a couple of small variations
//  on it.
//
//  TJulia is derived from TEscapeFractal, which is the base class of
//  those fractals that are created via an escape time iteration formula.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/24/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//  1)  The c component for a Julia is fixed and remains the same for
//      the whole process. So we store it's real/imaginary parts as members.
//
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TFracCache;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TJulia
// PREFIX: frac
// -----------------------------------------------------------------------------
class CIDFRACTALEXP TJulia : public TEscapeFractal
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TJulia();

        TJulia
        (
            const   TJulia&                 fracToCopy
        );

        TJulia
        (
            const   tCIDLib::TCard4         c4MaxIterations
            , const tCIDLib::TFloat8&       f8CReal
            , const tCIDLib::TFloat8&       f8CImag
        );

        ~TJulia() {}


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TJulia& operator=
        (
            const   TJulia&                 fracToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid CalcPixel
        (
            const   TQ1Point&               pntPixel
            , const TFPoint&                pntFractal
            ,       TFracCache&             fcachToStoreIn
        )   const;

        TFArea fareaDefSpace() const;


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __f8CReal
        //  __f8CImag
        //      These are the c component of the Mandelbrot formula. For a
        //      Julia these are set once and left alone, unlike the Mandelbrot
        //      which sets it to the z component for every pixel.
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8            __f8CReal;
        tCIDLib::TFloat8            __f8CImag;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TJulia,TEscapeFractal)
        DefPolyDup(TJulia)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Public, inherited methods
// -----------------------------------------------------------------------------
inline TFArea TJulia::fareaDefSpace() const
{
    return TFArea(-1.75, 1.5, -1.45, 1.45);
}

