//
// NAME: CIDFractal_Julia.Cpp
//
// DESCRIPTION: 
//
//  This module implements the TJulia class and a few smaller, more
//  specialized derivatives.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/22/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Facility includes
// -----------------------------------------------------------------------------
#include    "CIDFractal_.Hpp"


// -----------------------------------------------------------------------------
//  Do our standard members macro
// -----------------------------------------------------------------------------
RTTIData2(TJulia,TEscapeFractal)




// -----------------------------------------------------------------------------
//   CLASS: TJulia
//  PREFIX: frac
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TJulia: Constructors and Destructors
// -----------------------------------------------------------------------------

TJulia::TJulia() :

    TEscapeFractal(tCIDLib::ESymmetry_QuadrantFlip, 16)
    , __f8CReal(0.3)
    , __f8CImag(0.6)
{
}

TJulia::TJulia(const TJulia& fracToCopy) :

    TEscapeFractal(fracToCopy)
    , __f8CReal(fracToCopy.__f8CReal)
    , __f8CImag(fracToCopy.__f8CImag)
{
}

TJulia::TJulia( const   tCIDLib::TCard4     c4MaxIterations
                , const tCIDLib::TFloat8&   f8CReal
                , const tCIDLib::TFloat8&   f8CImag) :

    TEscapeFractal(tCIDLib::ESymmetry_QuadrantFlip, c4MaxIterations)
    , __f8CReal(f8CReal)
    , __f8CImag(f8CImag)
{
}


// -----------------------------------------------------------------------------
//  TJulia: Public operator
// -----------------------------------------------------------------------------

TJulia& TJulia::operator=(const TJulia& fracToAssign)
{
    if (this == &fracToAssign)
        return *this;

    TParent::operator=(fracToAssign);

    __f8CReal = fracToAssign.__f8CReal;
    __f8CImag = fracToAssign.__f8CImag;

    return *this;
}



// -----------------------------------------------------------------------------
//  TJulia: Public, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
TJulia::CalcPixel(  const   TQ1Point&   pntPixel
                    , const TFPoint&    pntFractal
                    ,       TFracCache& fcachToStoreIn) const
{
    // Get stuff into locals so we can get back their eventual new values
    tCIDLib::TFloat8 f8ZReal = pntFractal.f8X();
    tCIDLib::TFloat8 f8ZImag = pntFractal.f8Y();
    tCIDLib::TFloat8 f8CReal = __f8CReal;
    tCIDLib::TFloat8 f8CImag = __f8CImag;

    //
    //  Call the assembly function. When we come back, the values of the
    //  z and c components are as they were when we escaped (or failed to.)
    //  Since they are references, we now have the results in our locals.
    //
    tCIDLib::TCard4 c4Escape = TMandelbrot::c4MandelLoop
    (
        f8ZReal
        , f8ZImag
        , f8CReal
        , f8CImag
        , c4MaxIterations()
    );

    //
    //  According to our mapping mode we save one or the other of the
    //  values. We just call our parent and pass the candidate values.
    //  He will store the appropriate one.
    //
    _StoreValue
    (
        c4Escape
        , f8ZReal
        , f8ZImag
        , f8CReal
        , f8CImag
        , pntPixel
        , fcachToStoreIn
    );
}

// -----------------------------------------------------------------------------
//  Protected, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TJulia::_StreamFrom(TBinaryStream& strmToReadFrom)
{
    // Call our parent's version
    TParent::_StreamFrom(strmToReadFrom);

    strmToReadFrom >> __f8CReal;
    strmToReadFrom >> __f8CImag;
}

tCIDLib::TVoid TJulia::_StreamTo(TBinaryStream& strmToWriteTo) const
{
    // Call our parent's version
    TParent::_StreamTo(strmToWriteTo);

    strmToWriteTo << __f8CReal;
    strmToWriteTo << __f8CImag;
}
