//
// NAME: CIDFractal_Escape.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDFrac_Escape.Cpp module. This module
//  implements the TEscapeFractal class, which is a derivative of
//  TBaseFractal. This is the basis of a large family of fractals
//  (including Mandelbrots and Julias) that are created by calculating
//  how many iterations it takes for a formula to escape an arbitrary
//  boundary in the complex number plane.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/24/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TFracCache;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TEscapeFractal
// PREFIX: frac
// -----------------------------------------------------------------------------
class CIDFRACTALEXP TEscapeFractal : public TBaseFractal
{
    public :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        ~TEscapeFractal();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4 c4MaxIterations() const;

        tCIDLib::TCard4 c4MaxIterations
        (
            const   tCIDLib::TCard4         c4NewMax
        );

        tCIDFractal::EInsideMaps eInsideMap() const;

        tCIDFractal::EInsideMaps eInsideMap
        (
            const   tCIDFractal::EInsideMaps eInsideMap
        );

        tCIDFractal::EOutsideMaps eOutsideMap() const;

        tCIDFractal::EOutsideMaps eOutsideMap
        (
            const   tCIDFractal::EOutsideMaps eOutsideMap
        );


    protected :
        // ---------------------------------------------------------------------
        //  Hidden constructors and operators
        // ---------------------------------------------------------------------
        TEscapeFractal();

        TEscapeFractal
        (
            const   tCIDLib::ESymmetries    eSymmetry
            , const tCIDLib::TCard4         c4MaxIterations
        );

        TEscapeFractal
        (
            const   TEscapeFractal&         fracToCopy
        );

        TEscapeFractal& operator=
        (
            const   TEscapeFractal&         fracToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TEscapeFractal&         fracToCompare
        )   const;


        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


        // ---------------------------------------------------------------------
        //  Protected, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StoreValue
        (
            const   tCIDLib::TCard4         c4Escape
            , const tCIDLib::TFloat8        f8ZReal
            , const tCIDLib::TFloat8        f8ZImag
            , const tCIDLib::TFloat8        f8CReal
            , const tCIDLib::TFloat8        f8CImage
            , const TQ1Point&               pntPixel
            ,       TFracCache&             fcachTarget
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  If you add any members before the first or after the last, then
        //  change _StorageBytes.
        //
        //  __c4MaxIterations
        //      This is the maximum iterations to wait for an escape. If it
        //      does not escape by this point, then we just say it belongs
        //      to the prisoner set.
        //
        //  __eInsideMap
        //  __eOutsideMap
        //      These are the methods to use when coloring prisoner and escape
        //      points respectively.
        // ---------------------------------------------------------------------
        tCIDLib::TCard4             __c4MaxIterations;
        tCIDFractal::EInsideMaps    __eInsideMap;
        tCIDFractal::EOutsideMaps   __eOutsideMap;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TEscapeFractal,TBaseFractal)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TCard4 TEscapeFractal::c4MaxIterations() const
{
    return __c4MaxIterations;
}

inline tCIDLib::TCard4
TEscapeFractal::c4MaxIterations(const tCIDLib::TCard4 c4NewMax)
{
    __c4MaxIterations = c4NewMax;
    return __c4MaxIterations;
}

inline tCIDFractal::EInsideMaps TEscapeFractal::eInsideMap() const
{
    return __eInsideMap;
}

inline tCIDFractal::EInsideMaps
TEscapeFractal::eInsideMap(const tCIDFractal::EInsideMaps eInsideMap)
{
    __eInsideMap = eInsideMap;
    return __eInsideMap;
}

inline tCIDFractal::EOutsideMaps TEscapeFractal::eOutsideMap() const
{
    return __eOutsideMap;
}

inline tCIDFractal::EOutsideMaps
TEscapeFractal::eOutsideMap(const tCIDFractal::EOutsideMaps eOutsideMap)
{
    __eOutsideMap = eOutsideMap;
    return __eOutsideMap;
}
