//
// NAME: CIDFractal_Base.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDFractal_Base.Cpp module. This module
//  implements the basic class from which all fractals are derived. Each
//  derived class represents a family of fractals, from which many
//  specific fractals can be created by setting the fractal object's
//  options or overriding its per-pixel calculations.
//
//  c4CalcPixel() returns the escape time value to the caller. It is given
//  the point in pixel and fractal space terms, which is all that the
//  derived class should need to do a particular pixel (at least its all the
//  calc engine can generically give it.) Derived classes that need more
//  info of course just need to be able to calculate those values from
//  the passed pixel or fractal coordinates.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/24/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TFracCache;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TBaseFractal
// PREFIX: frac
// -----------------------------------------------------------------------------
class CIDFRACTALEXP TBaseFractal :

    public TObject, public MStreamable, public MDuplicable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        ~TBaseFractal();


        // ---------------------------------------------------------------------
        //  Public, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TVoid CalcPixel
        (
            const   TQ1Point&               pntPixel
            , const TFPoint&                pntFractal
            ,       TFracCache&             fcachToStoreIn
        )   const = 0;

        virtual TFArea fareaDefSpace() const = 0;


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDFractal::EElemTypes eElementType() const;

        tCIDFractal::EElemTypes eElementType
        (
            const   tCIDFractal::EElemTypes eElemType
        );


    protected       :
        // ---------------------------------------------------------------------
        //  Hidden constructors and operators
        // ---------------------------------------------------------------------
        TBaseFractal();

        TBaseFractal
        (
            const   tCIDFractal::EElemTypes eElemType
        );

        TBaseFractal
        (
            const   TBaseFractal&           fracToCopy
        );

        tCIDLib::TVoid operator=
        (
            const   TBaseFractal&           fracToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TBaseFractal&           fracToCompare
        )   const;


        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __eElemType
        //      This is the type of data cache element that this particular
        //      fractal needs. It will be updated as the derived object's
        //      attributes change, since it depends upon a number of different
        //      circumstances.
        // ---------------------------------------------------------------------
        tCIDFractal::EElemTypes     __eElemType;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBaseFractal,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------

inline tCIDFractal::EElemTypes TBaseFractal::eElementType() const
{
    return __eElemType;
}

inline tCIDFractal::EElemTypes
TBaseFractal::eElementType(const tCIDFractal::EElemTypes eElemType)
{
    return __eElemType;
}
