//
// NAME: CIDFractal_Base.Cpp
//
// DESCRIPTION: 
//
//  This module implements the core abstract fractal class. It defines the
//  very simple API that all fractals must adapt to.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/24/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Facility includes
// -----------------------------------------------------------------------------
#include    "CIDFractal_.Hpp"


// -----------------------------------------------------------------------------
//  Do our standard RTTI macros
// -----------------------------------------------------------------------------
RTTIData(TBaseFractal,TObject)



// -----------------------------------------------------------------------------
//   CLASS: TBaseFractal
//  PREFIX: frac
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TBaseFractal: Constructors and Destructors
// -----------------------------------------------------------------------------

TBaseFractal::~TBaseFractal()
{
}

// -----------------------------------------------------------------------------
//  TBaseFractal: Hidden constructors and operators
// -----------------------------------------------------------------------------

TBaseFractal::TBaseFractal() :

    __eElemType(tCIDFractal::EElemType_Card1)
{
}

TBaseFractal::TBaseFractal(const tCIDFractal::EElemTypes eElemType) :

    __eElemType(eElemType)
{
}

TBaseFractal::TBaseFractal(const TBaseFractal& fracToCopy) :

    __eElemType(fracToCopy.__eElemType)
{
}


tCIDLib::TVoid TBaseFractal::operator=(const TBaseFractal& fracToAssign)
{
    __eElemType = fracToAssign.__eElemType;
}


tCIDLib::TBoolean
TBaseFractal::operator==(const TBaseFractal& fracToCompare) const
{
    if (__eElemType != fracToCompare.__eElemType)
        return kCIDLib::False;

    return kCIDLib::True;
}

// -----------------------------------------------------------------------------
//  TBaseFractal: Protected, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TBaseFractal::_StreamFrom(TBinaryStream& strmToReadFrom)
{
    strmToReadFrom >> __eElemType;

    if (!::bIsValidEnum(__eElemType))
    {
        facCIDFractal.LogErr
        (
            __FILE__
            , __LINE__
            , kFractErrs::errcGen_InvalidValue
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_Unknown
            , TInteger(__eElemType)
            , facCIDFractal.strMsg(kFractMsgs::midBase_CacheElemSize)
        );
    }
}

tCIDLib::TVoid TBaseFractal::_StreamTo(TBinaryStream& strmToWriteTo) const
{
    strmToWriteTo << __eElemType;
}
