//
// NAME: CIDFractal_.Hpp
//
// DESCRIPTION:
//
//  This is the private header for the CIDFractal Facility. Source modules
//  of this Facility only need to include this one header to get access to
//  all public and private stuff.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/22/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  Import our own public header for internal consumption
// -----------------------------------------------------------------------------
#include    "CIDFractal.Hpp"


// -----------------------------------------------------------------------------
//  Include any intrafacility headers
// -----------------------------------------------------------------------------
#include    "CIDFractal_MessageIds.Hpp"


// -----------------------------------------------------------------------------
//  This is the intra facility types namespace. It is used to encapsulate any
//  non-class types, mostly enums or structures that are for internal use.
// -----------------------------------------------------------------------------
namespace tCIDFractal_
{
};


// -----------------------------------------------------------------------------
//  This is the intra facility constants namespace. It is used to encapsulate
//  any constant values unsed internally.
// -----------------------------------------------------------------------------
namespace kCIDFractal_
{
    //
    //  These are the strings used in emergency popups from this facility.
    //  These are the default values. At DLL init time, they are overridden
    //  with resource based strings. But, if that fails, these serve as the
    //  defaults.
    //
    const tCIDLib::Tch* const   pszTitle1 = L"CIDLib C++ Fractal Engine";
    const tCIDLib::Tch* const   pszTitle2 = L"Copyright (c) CIDCorp, 1992..1997";
};



// -----------------------------------------------------------------------------
//  Emergency popup macros. These make it simple to do popups internally.
//  They provide a lot of the needed information automatically.
// ----------------------------------------------------------------------------
#define _ERRPOPUP_(meth,msg,err) \
TFacCIDFratcal::PopUpErr \
( \
    __FILE__ \
    , meth \
    , __LINE__ \
    , kCIDFractal_::pszTitle1 \
    , kCIDFractal_::pszTitle2 \
    , msg \
    , kCIDLib::pszEmptyZStr \
    , err \
    , tCIDLib::ERadix_Dec \
);

#define _MSGPOPUP_(meth,msg) \
TFacCIDFractal::PopUpMsg \
( \
    __FILE__ \
    , meth \
    , __LINE__ \
    , kCIDFractal_::pszTitle1 \
    , kCIDFractal_::pszTitle2 \
    , msg \
    , kCIDLib::pszEmptyZStr \
);
