//
// NAME: CIDFractal.Hpp
//
// DESCRIPTION:
//
//  This is the public header for the CIDFractal Facility. The client
//  application only has to include this one header to access all of the
//  functionality of this facility.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/22/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//

#if !defined(_CIDFRACTAL_)
#define _CIDFRACTAL_

// -----------------------------------------------------------------------------
//  Import any needed underlying headers
// -----------------------------------------------------------------------------
#include    "CIDLib.Hpp"


// ----------------------------------------------------------------------------
//  Set up our import/export attributes
// ----------------------------------------------------------------------------
#if     defined(PROJ_CIDFRACTAL)
#define CIDFRACTALEXP   DLLEXPORT
#else
#define CIDFRACTALEXP   DLLIMPORT
#endif


// -----------------------------------------------------------------------------
//  Provide nul references to the forward referenced classes.
// -----------------------------------------------------------------------------
#define NUL_TBaseFractal        (*(TBaseFractal*)0)
#define NUL_TEscapeFract        (*(TEscapeFract*)0)
#define NUL_TFracCalcEngine     (*(TFracCalcEngine*)0)
#define NUL_TFracCache          (*(TFracCache*)0)
#define NUL_TFractalInfo        (*(TFractalInfo*)0)
#define NUL_TFracThread         (*(TFracThread*)0)
#define NUL_TJulia              (*(TJuia*)0)
#define NUL_TLyanpunov          (*(TLyapunov*)0)
#define NUL_TMandelbrot         (*(TMandelbrot*)0)


// -----------------------------------------------------------------------------
//  Include all of the public source module headers. These includes are in the
//  correct order of dependency so that the client application does not need
//  to worry about it.
// -----------------------------------------------------------------------------
#include    "CIDFractal_ResourceIds.H"
#include    "CIDFractal_ErrorIds.Hpp"
#include    "CIDFractal_Type.Hpp"
#include    "CIDFractal_Base.Hpp"
#include    "CIDFractal_Escape.Hpp"
#include    "CIDFractal_Mandelbrot.Hpp"
#include    "CIDFractal_Julia.Hpp"
#include    "CIDFractal_Lyapunov.Hpp"
#include    "CIDFractal_DataCache.Hpp"
#include    "CIDFractal_StdThread.hpp"
#include    "CIDFractal_CalcEngine.Hpp"
#include    "CIDFractal_SingleEngine.Hpp"
#include    "CIDFractal_MultiEngine.Hpp"
#include    "CIDFractal_ThisFac.Hpp"


// -----------------------------------------------------------------------------
//  Export the facility object
// -----------------------------------------------------------------------------
extern CIDFRACTALEXP TFacCIDFractal facCIDFractal;

#endif
