//
// NAME: CIDFractal.Cpp
//
// DESCRIPTION:
//
//  As the name implies this is the main module for the CIDFractal.Dll. This
//  module, like all CIDLib DLL facilities, handles the DLL init. It calls
//  any module inits that are required.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/22/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include 	"CIDFractal_.Hpp"
#include    "CIDLib_ModuleInit_.Hpp"



// -----------------------------------------------------------------------------
//  Data for global use
//
//  facCIDFractal
//      Declare the facility object. This is the only instance of this class
//      that is ever instantiated. It is exported to clients via the facility
//      public  header CIDFrac.Hpp.
// -----------------------------------------------------------------------------
TFacCIDFractal  facCIDFractal;


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
static tCIDLib::TVoid __InitCIDFractal
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Data for local use
//
//  __afnInitTerm
//      This is the list of init/term functions for this facility.
// ----------------------------------------------------------------------------
static tCIDLib::TModuleInitTermRec  __afnInitTerm[] =
{
      { __InitCIDFractal        , 0 , kFractMsgs::midMain_BaseInit }
};
static tCIDLib::TCard4      __c4InitCount = c4ArrayElems(__afnInitTerm);



// ----------------------------------------------------------------------------
//  Local functions
// ----------------------------------------------------------------------------

static tCIDLib::TVoid
__InitCIDFractal(   const   tCIDLib::EInitTerm      eInitTerm
                    , const tCIDLib::EGlobalStates  eGlobals
                    , const TModule&                modInit
                    , const tCIDLib::TCard4         c4MaxChars
                    ,       tCIDLib::Tch* const     pszFailReason)
{
    const tCIDLib::Tch* pszReason = modInit.pszLoadCIDMsg(kFractMsgs::midGen_Unknown);
    try
    {
        if ((eInitTerm == tCIDLib::EInitTerm_Initialize)
        &&  (eGlobals == tCIDLib::EGlobalState_Before))
        {
            //
            //  Load up a couple of primal strings that are used in emergency
            //  popups. These have default english values which will be there
            //  if these fail, but this will set up the translated versions.
            //
            //  We have to cast off the const'ness of the pointers in order
            //  to update them.
            //
            const tCIDLib::Tch* pszTmp;
            const tCIDLib::Tch* pszNC;

            pszReason = modInit.pszLoadCIDMsg(kFractMsgs::midMain_LoadTitles);
            pszTmp = modInit.pszLoadCIDMsg(kFractMsgs::midGen_Title1);
            if (pszTmp)
            {
                pszNC = const_cast<tCIDLib::Tch*>(kCIDFractal_::pszTitle1);
                pszNC = pszTmp;
            }

            pszTmp = modInit.pszLoadCIDMsg(kFractMsgs::midGen_Title2);
            if (pszTmp)
            {
                pszNC = const_cast<tCIDLib::Tch*>(kCIDFractal_::pszTitle2);
                pszNC = pszTmp;
            }

            // Load up the init module strings
            pszReason = modInit.pszLoadCIDMsg(kFractMsgs::midMain_LoadInitMods);
            for (tCIDLib::TCard4 c4Index = 0; c4Index < __c4InitCount; c4Index++)
            {
                __afnInitTerm[c4Index].pszDescription = modInit.pszLoadCIDMsg
                (
                    __afnInitTerm[c4Index].midDescription
                );
            }
        }
    }

    catch(...)
    {
        TRawStr::CopyStr(pszFailReason, pszReason, c4MaxChars);
        throw;
    }
}


// -----------------------------------------------------------------------------
//  DLL entry point. This guy is called on program startup when the .Dll is
//  loaded or threads start.
// -----------------------------------------------------------------------------

tCIDLib::TCard4 DLLINITAPI
CIDFractalInit( tCIDLib::TModHandle     hmodThis
                , tCIDLib::EInitTerm    eInitTerm
                , tCIDLib::TVoid*       pReserved)
{
    // Now do all of the module init
    if (!bCIDLib_DoModuleInitTerm
    (
        eInitTerm
        , hmodThis
        , tCIDLib::EModType_Dll
        , __c4InitCount
        , __afnInitTerm
        , kCIDFractal_::pszTitle1
        , kCIDFractal_::pszTitle2))
    {
        return 0;
    }
    return 1;
}
