//
// NAME: CIDCtrls_Border.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDCtrls_Border.Cpp module. This module
//  implements a number of derivations of the basic border class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/09/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: T3DBorder
//  PREFIX: wndb
// -----------------------------------------------------------------------------
class CIDCTRLEXP T3DBorder : public TWndBorder
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        T3DBorder();

        T3DBorder
        (
            const   tCIDLib::TCard4         c4Width
            , const tCIDWnd::E3DBorders     eType
        );

        T3DBorder
        (
            const   tCIDWnd::E3DBorders     eType
        );

        T3DBorder
        (
            const   T3DBorder&              wndbToCopy
        );

        ~T3DBorder();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4 c4Width() const;

        tCIDLib::TVoid Depress();

        tCIDLib::TVoid DrawBorder
        (
            const   TWindow&                wndTarget
            ,       TGraphicDevice&         gdevToUse
            , const TArea&                  areaBorder
        );

        tCIDWnd::E3DBorders eType() const;

        tCIDLib::TVoid Raise();


    private  :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __c4Width
        //      This is the width of the border.
        //
        //  __eType
        //      This is the type of 3D border we are drawing.
        // ---------------------------------------------------------------------
        tCIDLib::TCard4         __c4Width;
        tCIDWnd::E3DBorders     __eType;


        // ---------------------------------------------------------------------
        //  Do any needed magic macros
        // ---------------------------------------------------------------------
        RTTIMacros(T3DBorder,TWndBorder)
        DefPolyDup(T3DBorder)
};



// -----------------------------------------------------------------------------
//   CLASS: TLineBorder
//  PREFIX: wndb
// -----------------------------------------------------------------------------
class CIDCTRLEXP TLineBorder : public TWndBorder
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TLineBorder();

        TLineBorder
        (
            const   tCIDLib::TCard4         c4Width
        );

        TLineBorder
        (
            const   TLineBorder&            wndbToCopy
        );

        ~TLineBorder();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4 c4Width() const;

        tCIDLib::TVoid Depress();

        tCIDLib::TVoid DrawBorder
        (
            const   TWindow&                wndTarget
            ,       TGraphicDevice&         gdevToUse
            , const TArea&                  areaBorder
        );

        tCIDLib::TVoid Raise();


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __c4Width
        //      The width of the border in pixels. Its all within the draw
        //      area.
        // ---------------------------------------------------------------------
        tCIDLib::TCard4     __c4Width;


        // ---------------------------------------------------------------------
        //  Do any needed magic macros
        // ---------------------------------------------------------------------
        RTTIMacros(TLineBorder,TWndBorder)
        DefPolyDup(TLineBorder)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  T3DBorder: Public inherited methods
// -----------------------------------------------------------------------------
inline tCIDLib::TCard4 T3DBorder::c4Width() const
{
    return __c4Width;
}

inline tCIDLib::TVoid T3DBorder::Depress()
{
    if (__eType == tCIDWnd::E3DBorder_Raised)
        __eType = tCIDWnd::E3DBorder_Sunken;
}

inline tCIDWnd::E3DBorders T3DBorder::eType() const
{
    return __eType;
}

inline tCIDLib::TVoid T3DBorder::Raise()
{
    if (__eType == tCIDWnd::E3DBorder_Sunken)
        __eType = tCIDWnd::E3DBorder_Raised;
}


// -----------------------------------------------------------------------------
//  TLineBorder: Public, inherited methods
// -----------------------------------------------------------------------------
inline tCIDLib::TCard4 TLineBorder::c4Width() const
{
    return __c4Width;
}

inline tCIDLib::TVoid TLineBorder::Depress()
{
}

inline tCIDLib::TVoid TLineBorder::Raise()
{
}
