//
// NAME: CIDCtrls_Border.Cpp
//
// DESCRIPTION: 
//
//  This module implements some standard derivatives of the TWndBorder
//  class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/11/96
//
// COPYRIGHT: 1992..1996, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include    "CIDCtrls_.Hpp"


// -----------------------------------------------------------------------------
//  Do our RTTI macros
// -----------------------------------------------------------------------------
RTTIData(TLineBorder,TWndBorder)
RTTIData(T3DBorder,TWndBorder)



// -----------------------------------------------------------------------------
//   CLASS: TLineBorder
//  PREFIX: wbord
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TLineBorder: Constructors/Destructors
// -----------------------------------------------------------------------------

TLineBorder::TLineBorder() :

    __c4Width(1)
{
}

TLineBorder::TLineBorder(const tCIDLib::TCard4 c4Width) :

    __c4Width(c4Width)
{
}

TLineBorder::TLineBorder(const TLineBorder& wbordToCopy) :

    TWndBorder(wbordToCopy)
    , __c4Width(wbordToCopy.__c4Width)
{
}

TLineBorder::~TLineBorder()
{
}


// -----------------------------------------------------------------------------
//  TLineBorder: Public, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
TLineBorder::DrawBorder(const   TWindow&        wndTarget
                        ,       TGraphicDevice& gdevToUse
                        , const TArea&          areaBorder)
{
    TPen penToUse(wndTarget.rgbBorder());
    gdevToUse.Stroke(areaBorder, penToUse, __c4Width);
}



// -----------------------------------------------------------------------------
//   CLASS: T3DBorder
//  PREFIX: wbord
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  T3DBorder: Constructors/Destructors
// -----------------------------------------------------------------------------

T3DBorder::T3DBorder() :

    __c4Width(2)
    , __eType(tCIDWnd::E3DBorder_Raised)
{
}

T3DBorder::T3DBorder(   const   tCIDLib::TCard4     c4Width
                        , const tCIDWnd::E3DBorders eBorder) :

    __c4Width(c4Width)
    , __eType(eBorder)
{
}

T3DBorder::T3DBorder(const tCIDWnd::E3DBorders eBorder) :

    __c4Width(2)
    , __eType(eBorder)
{
}

T3DBorder::T3DBorder(const T3DBorder& wbordToCopy) :

    TWndBorder(wbordToCopy)
    , __c4Width(wbordToCopy.__c4Width)
    , __eType(wbordToCopy.__eType)
{
}

T3DBorder::~T3DBorder()
{
}


// -----------------------------------------------------------------------------
//  T3DBorder: Public, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
T3DBorder::DrawBorder(  const   TWindow&        wndTarget
                        ,       TGraphicDevice& gdevToUse
                        , const TArea&          areaBorder)
{
    gdevToUse.Draw3DBorder
    (
        __eType
        , areaBorder
        , __c4Width
        , wndTarget.rgbRaised()
        , wndTarget.rgbSunken()
    );
}
