//
//  FILE NAME: CIDCtrls.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 06/02/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main public header for the facility. It is the single point
//  of contact for the outside world. By including it, they get what we
//  have to offer. It also insures consistent order of inclusion which
//  is needed for the precompiled headers stuff to work.
//
//  CAVEATS/GOTCHAS:
//

#if         !defined(_CIDCTRLS_)
#define     _CIDCTRLS_

// ----------------------------------------------------------------------------
//  Set up our import/export attributes
// ----------------------------------------------------------------------------
#if     defined(PROJ_CIDCTRLS)
#define CIDCTRLEXP  DLLEXPORT
#else
#define CIDCTRLEXP  DLLIMPORT
#endif


// ----------------------------------------------------------------------------
//  Include our underlying headers
// ----------------------------------------------------------------------------
#include    "CIDWnd.Hpp"


// ----------------------------------------------------------------------------
//  Include our public headers
// ----------------------------------------------------------------------------
#include    "CIDCtrls_ErrorIds.Hpp"
#include    "CIDCtrls_Border.Hpp"

#endif
