//
//  FILE NAME: CIDCtrls.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 06/02/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main module of the facility. This guy provides the DLL
//  init function in order to handle initialization of any modules that
//  require it
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDCtrls_.Hpp"
#include    "CIDLib_ModuleInit_.Hpp"


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
static tCIDLib::TVoid _InitTermMain
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Data for local use
//
//  __afnInitTerm
//      This is the list of init term functions for this facility.
//
//  __c4InitCount
//      This is the count of elements in the init/term list.
// ----------------------------------------------------------------------------
static tCIDLib::TModuleInitTermRec  __afnInitTerm[] =
{
        { _InitTermMain         , L"Main Module" }
};
static tCIDLib::TCard4  __c4InitCount = c4ArrayElems(__afnInitTerm);



// ----------------------------------------------------------------------------
//  Local functions
// ----------------------------------------------------------------------------

static tCIDLib::TVoid
_InitTermMain(  const   tCIDLib::EInitTerm      eInitTerm
                , const tCIDLib::EGlobalStates  eGlobals
                , const TModule&                modInit
                , const tCIDLib::TCard4         c4MaxChars
                ,       tCIDLib::Tch* const     pszFailReason)
{
    const tCIDLib::Tch* pszPhase = L"Uknown";

    try
    {
        if ((eInitTerm == tCIDLib::EInitTerm_Initialize)
        &&  (eGlobals == tCIDLib::EGlobalState_Before))
        {
            //
            //  First of all load up some primal text that will be used
            //  in the popups if any errors occur. These are constants
            //  here so we cast away the const'ness to set them. If the
            //  load fails, then the compiled in default text is there
            //  to use.
            //
            pszPhase = L"Loading primal popup text";
            const tCIDLib::Tch* pszMsg;
            const tCIDLib::Tch* pszTmp;

            pszMsg  = modInit.pszLoadCIDMsg(kCtrlMsgs::midFac_Title1);
            if (pszMsg)
            {
                pszTmp = const_cast<tCIDLib::Tch*>(kCIDCtrls_::pszTitle1);
                pszTmp = pszMsg;
            }

            pszMsg  = modInit.pszLoadCIDMsg(kCtrlMsgs::midFac_Title2);
            if (pszMsg)
            {
                pszTmp = const_cast<tCIDLib::Tch*>(kCIDCtrls_::pszTitle2);
                pszTmp = pszMsg;
            }
        }
         else if ((eInitTerm == tCIDLib::EInitTerm_Terminate)
              &&  (eGlobals == tCIDLib::EGlobalState_After))
        {
        }
    }

    catch(...)
    {
        TRawStr::CopyCatStr
        (
            pszFailReason
            , c4MaxChars
            , pszPhase
            , L" failed"
        );
        throw;
    }
}


// ----------------------------------------------------------------------------
//  DLL entry point
// ----------------------------------------------------------------------------

tCIDLib::TCard4 DLLINITAPI
CIDCtrlsInit(   tCIDLib::TModHandle     hmodThis
                , tCIDLib::EInitTerm    eInitTerm
                , tCIDLib::TVoid*       pDummy)
{
    if (!bCIDLib_DoModuleInitTerm
    (
        eInitTerm
        , hmodThis
        , tCIDLib::EModType_Dll
        , __c4InitCount
        , __afnInitTerm
        , kCIDCtrls_::pszTitle1
        , kCIDCtrls_::pszTitle2))
    {
        return 0;
    }
    return 1;
}
