//
// NAME: CIDCrypto_Xor.Hpp
//
// DESCRIPTION:
//
//  TXorEncrypter is a very simple XOR based encrypter. It is provided just
//  completion. Its not a real encryption, but is often used just to be
//  discreet and avoid offense and such.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 12/02/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TXorEncrypter
//  PREFIX: cryp
// ----------------------------------------------------------------------------
class CIDCRYPTEXP TXorEncrypter : public TEncrypter
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TXorEncrypter();

        ~TXorEncrypter();


    protected :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 _c4Decrypt
        (
            const   tCIDLib::TCard1* const  pc1Cypher
            , const tCIDLib::TCard4         c4CypherBytes
            ,       tCIDLib::TCard1* const  pc1PlainBuf
            , const tCIDLib::TCard4         c4BufSize
        );

        tCIDLib::TCard4 _c4Encrypt
        (
            const   tCIDLib::TCard1* const  pc1Plain
            , const tCIDLib::TCard4         c4PlainBytes
            ,       tCIDLib::TCard1* const  pc1CypherBuf
            , const tCIDLib::TCard4         c4BufSize
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TXorEncrypter(const TXorEncrypter&);

        tCIDLib::TVoid operator=(const TXorEncrypter&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TXorEncrypter,TEncrypter)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  TXorEncrypter: Constructors and destructors
// ----------------------------------------------------------------------------
inline TXorEncrypter::TXorEncrypter()
{
}

inline TXorEncrypter::~TXorEncrypter()
{
}
