//
// NAME: CIDCrypto_Xor.Cpp
//
// DESCRIPTION:
//
//  This method provides the very simple Xor encrpytor.
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 12/02/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDCrypto_.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData2(TXorEncrypter,TEncrypter)


// ----------------------------------------------------------------------------
//   CLASS: TXorEncrypter
//  PREFIX: cryp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TXorEncrypter: Protected, inherited methods
// ----------------------------------------------------------------------------

tCIDLib::TCard4
TXorEncrypter::_c4Decrypt(  const   tCIDLib::TCard1* const  pc1CypherBuf
                            , const tCIDLib::TCard4         c4CypherBytes
                            ,       tCIDLib::TCard1* const  pc1PlainBuf
                            , const tCIDLib::TCard4         c4BufSize) 
{
    //
    //  Our scheme has a one to one relantionship between cypher and plain
    //  text, so we can go ahead and test for too small a target buffer
    //  before we bother doing any work.
    //
    if (c4BufSize < c4CypherBytes)
    {
        facCIDCrypto.LogErr
        (
            __FILE__
            , __LINE__
            , kCryptoErrs::errcGen_TargetTooSmall
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_CantDo
        );
    }

    for (tCIDLib::TCard4 c4Index = 0; c4Index < c4CypherBytes; c4Index++)
        pc1PlainBuf[c4Index] = pc1CypherBuf[c4Index] ^ 0xFF;

    // And return the number of bytes we decrypted
    return c4CypherBytes;
}

tCIDLib::TCard4
TXorEncrypter::_c4Encrypt(  const   tCIDLib::TCard1* const  pc1PlainBuf
                            , const tCIDLib::TCard4         c4PlainBytes
                            ,       tCIDLib::TCard1* const  pc1CypherBuf
                            , const tCIDLib::TCard4         c4BufSize)
{
    //
    //  Our scheme has a one to one relantionship between cypher and plain
    //  text, so we can go ahead and test for too small a target buffer
    //  before we bother doing any work.
    //
    if (c4BufSize < c4PlainBytes)
    {
        facCIDCrypto.LogErr
        (
            __FILE__
            , __LINE__
            , kCryptoErrs::errcGen_TargetTooSmall
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_CantDo
        );
    }

    for (tCIDLib::TCard4 c4Index = 0; c4Index < c4PlainBytes; c4Index++)
        pc1CypherBuf[c4Index] = pc1PlainBuf[c4Index] ^ 0xFF;

    // Return the number of bytes we encrypted
    return c4PlainBytes;
}
