//
// NAME: CIDCrypto_Key.Hpp
//
// DESCRIPTION:
//
//  TCryptoKey is a small class that is designed to make dealing with
//  decryption keys more safe and convenient. Keys can be ASCII text, UNICode
//  text, or binary data, so this class handles making all of those key
//  types look the same way to the encryption classes. And it deals with
//  issues of key length and such. Each keyed encryption class can create
//  a nested derivative of this class that enforce its key rules.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 10/24/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TCryptoKey
//  PREFIX: ckey
// ----------------------------------------------------------------------------
class CIDCRYPTEXP TCryptoKey :

    public TObject, public MDuplicable, public MStreamable
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TCryptoKey
        (
            const   TString&                strKey
        );

        TCryptoKey
        (
            const   TMemBuf&                mbufKey
            , const tCIDLib::TCard4         c4KeyBytes = 0
        );

        TCryptoKey
        (
            const   TCryptoKey&             ckeyToCopy
        );

        ~TCryptoKey();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TCryptoKey& operator=
        (
            const   TCryptoKey&             ckeyToAssign
        );


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 c4KeyBytes() const;

        const tCIDLib::TCard1* pc1Key() const;


    protected :
        // --------------------------------------------------------------------
        //  Hidden constructors
        // --------------------------------------------------------------------
        TCryptoKey();


    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4Bytes
        //      The number of bytes in the key array.
        //
        //  __pc1Key
        //      A pointer to an array of data bytes that make up the key.
        //      It is allocated and the data copied from the provided key
        //      data in the constructor.
        // --------------------------------------------------------------------
        tCIDLib::TCard4     __c4Bytes;
        tCIDLib::TCard1*    __pc1Key;


        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;
 


        // --------------------------------------------------------------------
        //  Magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TCryptoKey,TObject)
        DefPolyDup(TCryptoKey)
        BefriendFactory(TCryptoKey);
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  TCryptoKey: Public, non-virtual methods
// ----------------------------------------------------------------------------

inline tCIDLib::TCard4 TCryptoKey::c4KeyBytes() const
{
    return __c4Bytes;
}

inline const tCIDLib::TCard1* TCryptoKey::pc1Key() const
{
    return __pc1Key;
}
