//
// NAME: CIDCrypto_Blowfish.Hpp
//
// DESCRIPTION:
//
//  TBlowfishEncrypter is a derivative of the standard encryption class that
//  implements the (suprise) Blowfish encryption method. This is a public
//  domain encryption scheme designed by Bruce Schneier, the author of the
//  book "Applied Cryptography".
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 10/23/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TBlowfishEncrypter
//  PREFIX: cryp
// ----------------------------------------------------------------------------
class CIDCRYPTEXP TBlowfishEncrypter : public TEncrypter
{
    public  :
        // --------------------------------------------------------------------
        //  Public, static methods
        // --------------------------------------------------------------------
        static tCIDLib::TCard4 c4MinKeyBits();

        static tCIDLib::TCard4 c4MaxKeyBits();


        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TBlowfishEncrypter
        (
            const   TCryptoKey&             ckeyToUse
        );

        ~TBlowfishEncrypter();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        const TCryptoKey& ckeyThis() const;


    protected :
        // --------------------------------------------------------------------
        //  Protected, virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 _c4Decrypt
        (
            const   tCIDLib::TCard1* const  pc1Cypher
            , const tCIDLib::TCard4         c4CypherBytes
            ,       tCIDLib::TCard1* const  pc1PlainBuf
            , const tCIDLib::TCard4         c4BufSize
        );

        tCIDLib::TCard4 _c4Encrypt
        (
            const   tCIDLib::TCard1* const  pc1Plain
            , const tCIDLib::TCard4         c4PlainBytes
            ,       tCIDLib::TCard1* const  pc1CypherBuf
            , const tCIDLib::TCard4         c4BufSize
        );


    private :
        // --------------------------------------------------------------------
        //  Private constants
        // --------------------------------------------------------------------
        enum EConstants
        {
            c4NumSBoxes     = 4
            , c4SBoxSize    = 256
            , c4Rounds      = 16
            , c4PArraySize  = c4Rounds+2
            , c4BlockBits   = 64
            , c4BlockBytes  = 8
        };

        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TBlowfishEncrypter(const TBlowfishEncrypter&);

        tCIDLib::TVoid operator=(const TBlowfishEncrypter&);


        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 __c4Feistel
        (
            const   tCIDLib::TCard4         c4ToUse
        );

        tCIDLib::TVoid __DecryptBlock
        (
                    tCIDLib::TCard4&        c4Left
            ,       tCIDLib::TCard4&        c4Right
        );

        tCIDLib::TVoid __EncryptBlock
        (
                    tCIDLib::TCard4&        c4Left
            ,       tCIDLib::TCard4&        c4Right
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __ac4PArray
        //      The permutation data for the key we are using. It is set up
        //      during construction and used for the life of this encrypter
        //      object.
        //
        //  __ac4SBox
        //      The S-Box data for the key we are using. Its set up during
        //      construction and used for the life of this encrypter object.
        //
        //  __ckeyThis
        //      This is the key being used for encryption/decryption in
        //      this object.
        // --------------------------------------------------------------------
        tCIDLib::TCard4     __ac4PArray[c4PArraySize];
        tCIDLib::TCard4     __ac4SBox[c4NumSBoxes][c4SBoxSize];
        TCryptoKey          __ckeyThis;

        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBlowfishEncrypter,TEncrypter)
};

#pragma pack(pop)

// ----------------------------------------------------------------------------
//  TBlowfishEncrypter: Public, non-virtual methods
// ----------------------------------------------------------------------------
inline const TCryptoKey& TBlowfishEncrypter::ckeyThis() const
{
    return __ckeyThis;
}
