//
//  FILE NAME: CIDCrypto.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 10/21/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main public header for the facility. It is the single point
//  of contact for the outside world. By including it, they get what we
//  have to offer. It also insures consistent order of inclusion which
//  is needed for the precompiled headers stuff to work.
//
//  CAVEATS/GOTCHAS:
//

#if         !defined(_CIDCRYPTO_)
#define     _CIDCRYPTO_

// ----------------------------------------------------------------------------
//  Set up our import/export attributes
// ----------------------------------------------------------------------------
#if     defined(PROJ_CIDCRYPTO)
#define CIDCRYPTEXP DLLEXPORT
#else
#define CIDCRYPTEXP DLLIMPORT
#endif


// ----------------------------------------------------------------------------
//  Include our underlying headers
// ----------------------------------------------------------------------------
#include    "CIDLib.Hpp"


// ----------------------------------------------------------------------------
//  Include our public headers
// ----------------------------------------------------------------------------
#include "CIDCrypto_ErrorIds.Hpp"
#include "CIDCrypto_Key.Hpp"
#include "CIDCrypto_Blowfish.Hpp"
#include "CIDCrypto_Xor.Hpp"
#include "CIDCrypto_ThisFacility.Hpp"


// ----------------------------------------------------------------------------
//  Export the facility object. This stuff is defined in the main module.
// ----------------------------------------------------------------------------
extern CIDCRYPTEXP TFacCIDCrypto    facCIDCrypto;

#endif
