/*////////////////////////////////////////////////////////////////////////
//
// Copyright  1995 Somar Software, All Rights Reserved
/*/

#define _UNICODE
#define UNICODE
#define STRICT
#pragma warning(disable: 4001) /* double slash type comments */
#include <windows.h>
#pragma warning(disable: 4001)
#include <lm.h>
#pragma warning(disable: 4001)
#include <wchar.h>
#pragma hdrstop

#pragma warning(disable: 4001) /* double slash type comments */
#pragma warning(disable: 4057) // wprintf parm is array instead of pointer to short
#pragma warning(disable: 4514) // unreferenced inline functions

void PrintUsage();

////////////////////////////////////////////////////////////////////////
int wmain(int argc, wchar_t *argv[])
{
    PGROUP_USERS_INFO_0      pGlobalInfo;
    LPWSTR          pszGroup;
    WCHAR           szUserName[32];
    WCHAR           szDomain[32];
    WCHAR           szDC[32];
    DWORD           cchAvail;
    DWORD           cchNeeded;
    DWORD           dwRead;
    DWORD           dwTotal;    
    NET_API_STATUS  dwNetStat;
    LPBYTE          pb;

        // note: group name can never contain ?
    if (argc != 2 || wcsstr(argv[1], TEXT("?")) != NULL) {
        PrintUsage();
        return 2;
    }
    
    cchAvail = sizeof(szUserName) / sizeof(WCHAR);
    cchNeeded = GetEnvironmentVariable(TEXT("USERNAME"), szUserName, cchAvail);
    if (cchNeeded >= cchAvail) {
        wprintf(TEXT("internal error, szUserName too small\n"));
        return 2;
    }
    cchAvail = sizeof(szDomain) / sizeof(WCHAR);
    cchNeeded = GetEnvironmentVariable(TEXT("USERDOMAIN"), szDomain, cchAvail);
    if (cchNeeded >= cchAvail) {
        wprintf(TEXT("internal error, szDomain too small\n"));
        return 2;
    }
    pszGroup = argv[1];
    #ifdef _DEBUG
    wprintf(TEXT("Group   =%s\n"), pszGroup);
    wprintf(TEXT("UserName=%s\n"), szUserName);
    wprintf(TEXT("Domain  =%s\n"), szDomain);
    #endif

    dwNetStat = NetGetDCName(NULL, szDomain, &pb);
    if (dwNetStat != ERROR_SUCCESS) {
        wprintf(TEXT("internal error, NetGetDCName rc=%lu\n"), dwNetStat);
        return 2;
    }
    else {
        cchAvail = sizeof(szDC) / sizeof(WCHAR);
        wcsncpy(szDC, (LPWSTR) pb, cchAvail);
        dwNetStat = NetApiBufferFree(pb);

        #ifdef _DEBUG
        wprintf(TEXT("DC      =%s\n"), szDC);
        #endif 

        dwNetStat = NetUserGetGroups(szDC, szUserName, 0, 
                                     &pb, 4096, &dwRead, &dwTotal);
        if (dwNetStat != ERROR_SUCCESS) {
            wprintf(TEXT("internal error, NetUserGetGroups rc=%lu\n"), dwNetStat);
            return 2;
        }
        else {
            if (dwRead < dwTotal) {
                wprintf(TEXT("internal error, NetUserGetGroup dwRead=%lu dwTotal=%lu\n"), 
                        dwRead, dwTotal);
                return 2;
            }
            else {
                pGlobalInfo = (PGROUP_USERS_INFO_0) pb;
                while (dwRead-- > 0) {
                    #ifdef _DEBUG
                    wprintf(TEXT("Global Group=%s\n"), pGlobalInfo->grui0_name);
                    #endif 
                    if (lstrcmpi(pszGroup, pGlobalInfo->grui0_name) == 0) {
                        #ifdef _DEBUG
                        wprintf(TEXT("!match found\n"));
                        #endif 
                        return 0;
                    }
                    pGlobalInfo++;
                }
            }
            NetApiBufferFree(pb);
        }
    }

    #ifdef _DEBUG
    wprintf(TEXT("no match found\n"));
    #endif 
    return 1;
}

////////////////////////////////////////////////////////////////////////
void PrintUsage()
{
    wprintf(TEXT("Usage: testgrp groupname\n"));
    wprintf(TEXT("   Return code = 0 if current user is member of groupname\n"));
    wprintf(TEXT("   Return code = 1 if current user not a member of groupname\n"));
    wprintf(TEXT("   Return code = 2 if error\n"));
    wprintf(TEXT("   Quotes around groupname required if embedded spaces\n"));
    wprintf(TEXT("   Groupname is not case-sensitive\n"));
    wprintf(TEXT("   Groupname must be a global group\n"));
    wprintf(TEXT("Example:\n"));
    wprintf(TEXT("   testgrp \"domain admins\"\n"));
    wprintf(TEXT("   if errorlevel 1 goto skip\n"));
    wprintf(TEXT("   echo do special processing for members of domain admins group\n"));
    wprintf(TEXT("   :skip\n"));
    wprintf(TEXT("Send bug reports and comments to 72202.2574@compuserve.com\n"));
    wprintf(TEXT("Visit the Somar Software Web site at http://www.somar.com\n"));
}
