//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_AUDIT_SUCCESS    0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: LOG_CATEGORY_SERVER
//
// MessageText:
//
//  Server
//
#define LOG_CATEGORY_SERVER              0x00000001L

//
// MessageId: LOG_CATEGORY_STARTUP
//
// MessageText:
//
//  Program Start
//
#define LOG_CATEGORY_STARTUP             0x00000002L

//
// MessageId: LOG_CATEGORY_SUNTSTARTSTOP
//
// MessageText:
//
//  Program Start
//
#define LOG_CATEGORY_SUNTSTARTSTOP       0x00000003L

//
// MessageId: MSG_STARTUP_SUCCESS
//
// MessageText:
//
//  SuNT Server started successfully
//
#define MSG_STARTUP_SUCCESS              0x400003E8L

//
// MessageId: MSG_STARTUP_FAILURE
//
// MessageText:
//
//  SuNT Server failed to start. Reason: %1. 
//
#define MSG_STARTUP_FAILURE              0xC00003E9L

//
// MessageId: MSG_STOP
//
// MessageText:
//
//  SuNT Server stopped
//
#define MSG_STOP                         0x400003EAL

//
// MessageId: MSG_SU_SUCCESS
//
// MessageText:
//
//  The user %1 started the program %2 under the account %3 successfully
//
#define MSG_SU_SUCCESS                   0x400007D0L

//
// MessageId: MSG_SU_FAILURE
//
// MessageText:
//
//  The user %1 failed to start the program %2 under the account %3. Reason: %4.
//
#define MSG_SU_FAILURE                   0x800007D1L

//
// MessageId: MSG_INVALID_COMMANDLINE
//
// MessageText:
//
//  %1
//
#define MSG_INVALID_COMMANDLINE          0x800007D2L

