#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

char * szUsername;		// username from commandline
char * szPassword;		// password for the user
char * szApplication;	// commandline to run

char szEnteredPass[30];	// password if not from the commandline
char szIn[622];
char szOut[100];

void Usage(void);
void ProcessCommandLine(int argc, char * argv[]);
void GetPassword(void);

main(int argc, char * argv[])
{
	LPSTR   lpszPipeName = "\\\\.\\pipe\\susrv";
	DWORD   dwBytesRead;
    BOOL    bRet;
    

	// check commandline
	ProcessCommandLine(argc, argv);
	wsprintf(szIn, "%s\n%s\n%s\n", szApplication, szUsername, szPassword);

	//connect to server and wait till it returns
	bRet = CallNamedPipeA(lpszPipeName,
    		szIn, sizeof(szIn),
            szOut, sizeof(szOut),
            &dwBytesRead, NMPWAIT_WAIT_FOREVER);

	if (!bRet) 
	{
        printf("sunt: Cannot connect to SuNT Server. Error: %u", GetLastError());
        exit(1);
    }
	// give result
    printf("received: %s\n", szOut);

	return 0;
}

void Usage(void)
{		
	printf("sunt - starts a program with a specific user account\n");
	printf("Usage:    sunt program username [password] \n");
	printf("where\n");
	printf("program:  commandline to run, must be quoted if it contains white-spaces\n");
	printf("username: username of the account under which to run the program\n");
	printf("password: password for the account, if ommitted, sunt asks for it\n");
	exit(1);
}

void ProcessCommandLine(int argc, char * argv[])
{
	if (argc < 3)
		Usage();
	szApplication = argv[1];
	szUsername = argv[2];
	if (argc == 3)
	{	
		GetPassword();
	}
	else
	{	
		szPassword = argv[3];
	}
}
				
void GetPassword(void)
{
	int i;
	int ch;
	i = 0;
	printf("Password: ");
	while(((ch = _getch()) != 13) && (i < 30))
	{
		szEnteredPass[i++] = ch;
		_putch(42);
	}
	szEnteredPass[i] = 0;
	szPassword = szEnteredPass;
}
