/*

METAFILE.H - Header file that contains definitions to handle metafiles
             (C) 1993, Dennis CHUAH

*/


#ifndef __METAFILE_H
#define __METAFILE_H

#ifndef RC_INVOKED
#pragma option -a-
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* Metafile resource ID */
#define METAFILE	2000


/* Placeable metafile header */
typedef struct tagMETAFILEHEADER
  {DWORD key;		// Must be 0x9AC6CDD7L
   HANDLE hmf;		// Must be 0
   RECT bbox;
   WORD inch;
   DWORD reserved;	// Must be 0L
   WORD checksum;
  } METAFILEHEADER;


/* Loads a resource metafile */
HMETAFILE WINAPI LoadMetafile (HINSTANCE hInstance, LPCSTR lpMetafileName);

/* Loads in a disk metafile, regardless of whether it is a placeable one */
HMETAFILE WINAPI GetMetaFileBetter (LPCSTR path, METAFILEHEADER far *lpMh);

/* Copies a metafile with optional placeable header */
HMETAFILE WINAPI CopyMetaFileBetter (HMETAFILE hmfSrc, LPCSTR lpszFile,
                                     METAFILEHEADER far *lpMh);

#ifdef __cplusplus
}
#endif

#endif /* __METAFILE_H */

